#include "encoder.h"
#include "mbed.h"

Encoder::Encoder(PinName APin, PinName BPin, PinName ZPin) : A(APin) , B(BPin) , Z(ZPin){
    A.rise(this,&Encoder::flag);
    init();
}

void Encoder::init(void){
    count = 0;
    zcount = 0;
}

void Encoder::flag(void){
  if(B == true){
    count++;
    if(Z == true){
        zcount++;
    }
  }else{
    count--;
    if(Z == true){
        zcount--;
    }
  }
}

float Encoder::read_rotate(){
    return (float)(count / 300.0);
}

int Encoder::read_z(){
    return zcount;
}


