#include "mbed.h"
#include "XQ_servo.h"


double XQ_servo::map(double x, double in_min, double in_max, double out_min, double out_max){
  return (x - in_min) * (out_max - out_min) / (in_max - in_min) + out_min;
}

XQ_servo::XQ_servo(PinName signal) : pwm(signal){
}

void XQ_servo::move(float value){
    value = (int)map(value, 1.0, 0.0, 700, 2300);
    pwm.pulsewidth_us(value);
}
    