 
#ifndef TCS3200_H
#define TCS3200_H
 
#include "mbed.h"
 
#define RED   40
#define GREEN 41
#define BLUE  42
#define CLEAR 43

class TCS3200 {
  public:   
    /** Create a TCS3200 object connected to the specified pins.
    * @param S0 Frequency scaling output pin S0
    * @param S1 Frequency scaling output pin S1
    * @param S2 Photo diode selection output pin S2
    * @param S3 Photo diode selection output pin S3
    * @param OUT Frequency input pin
    */
    TCS3200(PinName S2, PinName S3, PinName OUT);
    
    /** Reads the output signal's HIGH pulse for RED.
    * @param 
    *     None
    * @return 
    *     Duration as nanoseconds (ns).
    */
    long ReadRed();
    
    /** Reads the output signal's HIGH pulse for GREEN.
    * @param 
    *     None
    * @return 
    *     Duration as nanoseconds (ns).
    */
    long ReadGreen();
    
    /** Reads the output signal's HIGH pulse for BLUE.
    * @param 
    *     None
    * @return 
    *     Duration as nanoseconds (ns).
    */
    long ReadBlue();
    
    /** Reads the output signal's HIGH pulse for CLEAR.
    * @param 
    *     None
    * @return 
    *     Duration as nanoseconds (ns).
    */
    long ReadClear();
    
    /** Sets the mode of operation. 
    * @param 
    *     mode POWERDOWN, SCALE_2 (2% scaling), SCALE_20 (20% scaling), SCALE_100 (100% scaling).
    * @return 
    *     None
    */
    
  private:
    DigitalOut mS2;
    DigitalOut mS3;
    InterruptIn signal;
    Timer timer;
    Ticker ticker;
    int coler;
    long pulsewidth;
    long red_pulsewidth;
    long green_pulsewidth;
    long blue_pulsewidth;
    long clear_pulsewidth;
    void HighTrigger();
    void LowTrigger();
    void fliper();
};
 
#endif