#include "TCS3200.h"
#include "mbed.h"
 
 
TCS3200::TCS3200(PinName S2, PinName S3, PinName OUT) : 
mS2(S2), mS3(S3), signal(OUT){
    signal.rise(this,&TCS3200::HighTrigger);
    signal.fall(this,&TCS3200::LowTrigger);
    ticker.attach(this,&TCS3200::fliper,0.1);
    coler = RED;
    mS2 = 0.0;
    mS3 = 0.0;
}

void TCS3200::fliper(){
    switch(coler){
        case RED:
        red_pulsewidth = pulsewidth;
        mS2 = 1.0;
        mS3 = 1.0;
        coler = GREEN;
        break;
        case GREEN:
        green_pulsewidth = pulsewidth;
        mS2 = 0.0;
        mS3 = 1.0;
        coler = BLUE;
        break;
        case BLUE:
        blue_pulsewidth = pulsewidth;
        mS2 = 1.0;
        mS3 = 0.0;
        coler = CLEAR;
        break;
        case CLEAR:
        clear_pulsewidth = pulsewidth;
        mS2 = 0.0;
        mS3 = 0.0;
        coler = RED;
        break;
        default:
        break;
    }
}
    
long TCS3200::ReadRed(){
    return(red_pulsewidth);
}

long TCS3200::ReadGreen(){
    return(green_pulsewidth);
}

long TCS3200::ReadBlue(){
    return(blue_pulsewidth);
}

long TCS3200::ReadClear(){
    return(clear_pulsewidth);
}

void TCS3200::HighTrigger() {
    timer.start();
}

void TCS3200::LowTrigger() {
    timer.stop();
    pulsewidth = timer.read_us();
    timer.reset();
}