#include "mbed.h"
#include "Serialservo.h"

long Serialservo::map(long x, long in_min, long in_max, long out_min, long out_max){
  return (x - in_min) * (out_max - out_min) / (in_max - in_min) + out_min;
}

Serialservo::Serialservo(PinName TX, PinName RX, PinName Dout) : ser(TX, RX), switching(Dout){
}

//初期化関数
void Serialservo::init(){
    ser.baud(115200);
    ser.format(8, Serial::Even, 1);
    //ser.attach(NULL, Serial::TxIrq);
    switching = 1;
    tx_data[0] = 0;
    tx_data[1] = 0;
    tx_data[2] = 0;
}

//データ送信完了待ち関数
void Serialservo::flush(){
    //wait_ms(0.1);
    ser.attach(NULL, Serial::TxIrq);
    switching = 0;//受信モードに切替
}

//データ送信関数
void Serialservo::transmission(){
    switching = 1;//送信モードに切り替え
    ser.putc(tx_data[0]);
    ser.putc(tx_data[1]);
    ser.putc(tx_data[2]);
    wait(0.005);
    //ser.attach(this,&Serialservo::flush, Serial::TxIrq);
}

//ポジション設定
void Serialservo::move(char id,int pos){
    pos = (int)map((int)pos, 0, 270, 3500, 11500);
    int temp1 = (pos & 0x3F80) >> 7;
    int temp2 = pos & 0x7f;
    tx_data[0] = ICS_POS_CMD | id;
    tx_data[1] = (unsigned char)temp1;
    tx_data[2] = (unsigned char)temp2;
    transmission();//送信
}

//保持トルク設定
void Serialservo::stretch(char id,int str){
    int temp1 = SUB_ST_COMMND;
    int temp2 = str;
    tx_data[0] = ICS_PARA_WRITE_COMMND | id;
    tx_data[1] = (unsigned char)temp1;
    tx_data[2] = (unsigned char)temp2;
    transmission();//送信
}

//スピード設定
void Serialservo::speed(char id,int spe){
    int temp1 = SUB_SP_COMMND;
    int temp2 = spe;
    tx_data[0] = ICS_PARA_WRITE_COMMND | id;
    tx_data[1] = (unsigned char)temp1;
    tx_data[2] = (unsigned char)temp2;
    transmission();//送信
}
