#include "Servo.h"
#include "mbed.h"

Servo::Servo(PinName Pin) : ServoPin(Pin) {}

void Servo::init(int pos,float speed){
    update(speed);
    currentPosition = pos;
    newPosition = pos;
    Speed.attach_us(this, &Servo::move, 5000);
}

void Servo::update(float speed){
    if(speed <= 0.0){
        currentPosition = newPosition;
    }else if(speed > 1.0){
        speed = 1.0;
    }
    _speed = speed * 5; 
}

void Servo::move(){
    float dev = newPosition - currentPosition;
    if( dev > 0 ){
        currentPosition += _speed;
    }else if( dev < 0 ){
        currentPosition -= _speed;
    }
    int pulse = int(currentPosition);
    ServoPin.pulsewidth_us(pulse);
}

void Servo::setPosition(int pos,float speed){
    newPosition = pos;
    update(speed);
}
