#include "PID.h"
#include "mbed.h"

PID::PID(double kp, double ki, double kd, double setpoint){
    KP = kp;
    KI = ki;
    KD = kd;
    Setpoint = setpoint;
    //init();
}

void PID::init(){
  //timer.reset();
  //timer.start();
  preP = 0;
  P = 0;
  I = 0;
  D = 0;
}

double PID::compute(double input){
    //dt = timer.read_ms() / 10;
    //timer.reset();
    P  = Setpoint - input;
    I += P;
    D  = (P - preP);
    preP = P;
    return (KP * P + KI * I + KD * D);
}
