#include "mbed.h"
#include "XNucleo53L0A1.h"
#include <stdio.h>

#define VL53L0_I2C_SDA   D4
#define VL53L0_I2C_SCL   D5

static XNucleo53L0A1 *board=NULL;
DigitalOut dout(D8);
DigitalOut Led(D13);
int count = 0;


int main(){   
    int status;
    uint32_t distance = 0;

    DevI2C *device_i2c = new DevI2C(VL53L0_I2C_SDA, VL53L0_I2C_SCL);
    
    board = XNucleo53L0A1::instance(device_i2c, A2, D8, D2);
    status = board->init_board();
    if (status) {
        return 0;
    }
    dout = 0.0;
    Led = 0.0;
    while (1) {
        status = board->sensor_centre->get_distance(&distance);
        if (status == VL53L0X_ERROR_NONE) {
           if(distance <= 100){
                count++;
            }else{
                count--;
            }
        }else{
            count--;
        }
        if(count >= 20){
            count = 20;
        }else if(count <= -10){
            count = -10; 
        }
        if(count >= 10){
            dout = 1.0;
            Led = 1.0;
        }else if(count <= 0){
            dout = 0.0;
            Led = 0.0;
        }
    }
}
