/*
 * mbed library program
 *  Set low power condition only for nRF51822 BLE chip
 *
 *  Copyright (c) 2016 Kenji Arai / JH1PJL
 *  http://www.page.sannet.ne.jp/kenjia/index.html
 *  http://mbed.org/users/kenjiArai/
 *      Started:    April     30th, 2016
 *      Revised:    June      11th, 2016
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED,
 * INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE
 * AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
 * DAMAGES OR OTHER  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

#ifndef NRF51_LOWPWR_H
#define NRF51_LOWPWR_H

#include "mbed.h"

 
 ////////////// DATA TYPE DEFINITION ///////////////////////
typedef struct {
    bool    std_printf_function;
    bool    serial_function;
    bool    i2c_function;
    bool    spi_function;
    bool    spi_slave_function;
    bool    pwm_functions;
    bool    analog_function;
} nRF51_LOWPWR_TypeDef;

/** Set low power condition only for nRF51822 BLE chip
 *
 * @code
 * #include    "mbed.h"
 * #include    "BLE.h"
 * #include    "nRF51_lowpwr.h"
 *
 * const nRF51_LOWPWR_TypeDef  lowpwr_table = 
 *                       {
 *                           false, // VCOM
 *                           false, // UART
 *                           true,  // I2C
 *                           false, // SPI
 *                           false, // SPI Slave
 *                           false, // PWM
 *                           false  // ADC
 *                       };
 *
 * int main() {
 *     LowPwr set_lowpwr(&lowpwr_table);
 *     while(1) {
 *          ble.waitForEvent();
 *     }
 * }
 * @endcode
 */

class LowPwr{
public:
    /** Configure data pin
      * @param parameters table for Enable/Disable peripheral functions
      */
    LowPwr(const nRF51_LOWPWR_TypeDef *param);   
};

#ifndef TARGET_NRF51822
#error  "Only for TY51822r3 (If your chip is nRF51822, it should work(I haven't tested)."
#endif

#endif  // NRF51_LOWPWR_H
