/*
 * mbed library program
 *  Set low power condition only for nRF51822 BLE chip
 *
 *  Copyright (c) 2016 Kenji Arai / JH1PJL
 *  http://www.page.sannet.ne.jp/kenjia/index.html
 *  http://mbed.org/users/kenjiArai/
 *      Started:    April     30th, 2016
 *      Revised:    June      11th, 2016
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED,
 * INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE
 * AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
 * DAMAGES OR OTHER  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

#include "mbed.h"
#include "nRF51_lowpwr.h"
#include "nrf_delay.h"

LowPwr::LowPwr(const nRF51_LOWPWR_TypeDef *param){
    if ((param->std_printf_function == false) && (param->serial_function == false)){
        //#warning    "Disable Serial function (cannot use printf)!"
        NRF_UART0->ENABLE           = 0;
        nrf_delay_us(5);
        NRF_UART0->EVENTS_RXDRDY    = 0;
        nrf_delay_us(5);
        //NRF_UART0->INTENCLR = 0x00020287;
        NRF_UART0->INTENCLR         = 0xffffffff;
        nrf_delay_us(5);
        NRF_UART0->TASKS_STOPRX     = 1;
        nrf_delay_us(5);
        NRF_UART0->POWER            = 0;
        nrf_delay_us(5);
    }
    if (param->i2c_function == false){
        //#warning    "Disable I2C function!"
        NRF_TWI0->EVENTS_ERROR      = 0;
        nrf_delay_us(5);
        NRF_TWI0->INTENCLR          = 0xffffffff;
        nrf_delay_us(5);
        NRF_TWI0->ENABLE            = 0;
        nrf_delay_us(5);
        NRF_TWI0->POWER             = 0;
        nrf_delay_us(5);
        NRF_TWI1->EVENTS_ERROR      = 0;
        nrf_delay_us(5);
        NRF_TWI1->INTENCLR          = 0xffffffff;
        nrf_delay_us(5);
        NRF_TWI1->ENABLE            = 0;
        nrf_delay_us(5);
        NRF_TWI1->POWER             = 0;
    }
    if ((param->spi_function == false) && (param->spi_slave_function == false)){
        //#warning    "Disable SPI function!"
        NRF_SPI0->INTENCLR          = 0xffffffff;
        nrf_delay_us(5);
        NRF_SPI0->ENABLE            = 0;
        nrf_delay_us(5);
        NRF_SPI0->POWER             = 0;
        nrf_delay_us(5);
        NRF_SPI1->INTENCLR          = 0xffffffff;
        nrf_delay_us(5);
        NRF_SPI1->ENABLE            = 0;
        nrf_delay_us(5);
        NRF_SPI1->POWER             = 0;
        nrf_delay_us(5);
        NRF_SPIS1->INTENCLR          = 0xffffffff;
        nrf_delay_us(5);
        NRF_SPIS1->ENABLE            = 0;
        nrf_delay_us(5);
        NRF_SPIS1->POWER             = 0;
    }
    if (param->pwm_functions == false){
        //#warning    "Disable PWM function!"
        // Timer0,1,2
        NRF_TIMER0->INTENCLR        = 0xffffffff;
        nrf_delay_us(5);
        NRF_TIMER0->TASKS_STOP      = 1;
        nrf_delay_us(5);
        NRF_TIMER0->POWER           = 0;
        nrf_delay_us(5);
        NRF_TIMER1->INTENCLR        = 0xffffffff;
        nrf_delay_us(5);
        NRF_TIMER1->TASKS_STOP      = 1;
        nrf_delay_us(5);
        NRF_TIMER1->POWER           = 0;
        nrf_delay_us(5);
        NRF_TIMER2->INTENCLR        = 0xffffffff;
        nrf_delay_us(5);
        NRF_TIMER2->TASKS_STOP      = 1;
        nrf_delay_us(5);
        NRF_TIMER2->POWER           = 0;
        nrf_delay_us(5);
        // PPI
        NRF_PPI->TASKS_CHG[0].DIS   = 1;
        NRF_PPI->TASKS_CHG[1].DIS   = 1;
        NRF_PPI->TASKS_CHG[2].DIS   = 1;
        NRF_PPI->TASKS_CHG[3].DIS   = 1;
        for (uint8_t n = 0; n <16 ; n++){
            NRF_PPI->CH[n].TEP = 0;
            NRF_PPI->CH[n].EEP = 0;
        }
    }
    if (param->analog_function == false){
        //#warning    "Disable ADC function!"
        NRF_ADC->TASKS_STOP         = 1;
        nrf_delay_us(5);
        NRF_ADC->CONFIG             = 0x18;
        nrf_delay_us(5);
        NRF_ADC->ENABLE             = 0;
        nrf_delay_us(5);
        NRF_ADC->POWER              = 0;
        nrf_delay_us(5);
    }
}
