/* Copyright (c) 2017-2019 ARM Limited
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/*******************************************************************************
 * !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
 * THIS FILE IS AN AUTO-GENERATED FILE - DO NOT MODIFY IT.
 * !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
 * Template Version 1.0
 * Generated by tools/psa/generate_partition_code.py Version 1.1
 ******************************************************************************/

#ifndef __MBED_SPM_PARTITIONS_H___
#define __MBED_SPM_PARTITIONS_H___


/****************** Common definitions ****************************************/

/* PSA reserved event flags */
#define PSA_RESERVED1_POS (1UL)
#define PSA_RESERVED1_MSK (1UL << PSA_RESERVED1_POS)

#define PSA_RESERVED2_POS (2UL)
#define PSA_RESERVED2_MSK (1UL << PSA_RESERVED2_POS)

/****************** Service Partitions ****************************************/

/* -----------------------------------------------------------------------------
 * ATTEST_SRV defines
 * -------------------------------------------------------------------------- */
#define ATTEST_SRV_ID 37

#define ATTEST_SRV_ROT_SRV_COUNT (3UL)
#define ATTEST_SRV_EXT_ROT_SRV_COUNT (7UL)


#define ATTEST_SRV_WAIT_ANY_IRQ_MSK (0)

#define PSA_ATTEST_GET_TOKEN_POS (4UL)
#define PSA_ATTEST_GET_TOKEN (1UL << PSA_ATTEST_GET_TOKEN_POS)
#define PSA_ATTEST_GET_TOKEN_SIZE_POS (5UL)
#define PSA_ATTEST_GET_TOKEN_SIZE (1UL << PSA_ATTEST_GET_TOKEN_SIZE_POS)
#define PSA_ATTEST_INJECT_KEY_POS (6UL)
#define PSA_ATTEST_INJECT_KEY (1UL << PSA_ATTEST_INJECT_KEY_POS)

#define ATTEST_SRV_WAIT_ANY_SID_MSK (\
    PSA_ATTEST_GET_TOKEN | \
    PSA_ATTEST_GET_TOKEN_SIZE | \
    PSA_ATTEST_INJECT_KEY)


/* -----------------------------------------------------------------------------
 * CRYPTO_SRV defines
 * -------------------------------------------------------------------------- */
#define CRYPTO_SRV_ID 35

#define CRYPTO_SRV_ROT_SRV_COUNT (11UL)
#define CRYPTO_SRV_EXT_ROT_SRV_COUNT (4UL)


#define CRYPTO_SRV_WAIT_ANY_IRQ_MSK (0)

#define PSA_CRYPTO_INIT_POS (4UL)
#define PSA_CRYPTO_INIT (1UL << PSA_CRYPTO_INIT_POS)
#define PSA_MAC_POS (5UL)
#define PSA_MAC (1UL << PSA_MAC_POS)
#define PSA_HASH_POS (6UL)
#define PSA_HASH (1UL << PSA_HASH_POS)
#define PSA_ASYMMETRIC_POS (7UL)
#define PSA_ASYMMETRIC (1UL << PSA_ASYMMETRIC_POS)
#define PSA_SYMMETRIC_POS (8UL)
#define PSA_SYMMETRIC (1UL << PSA_SYMMETRIC_POS)
#define PSA_AEAD_POS (9UL)
#define PSA_AEAD (1UL << PSA_AEAD_POS)
#define PSA_KEY_MNG_POS (10UL)
#define PSA_KEY_MNG (1UL << PSA_KEY_MNG_POS)
#define PSA_RNG_POS (11UL)
#define PSA_RNG (1UL << PSA_RNG_POS)
#define PSA_CRYPTO_FREE_POS (12UL)
#define PSA_CRYPTO_FREE (1UL << PSA_CRYPTO_FREE_POS)
#define PSA_KEY_DERIVATION_POS (13UL)
#define PSA_KEY_DERIVATION (1UL << PSA_KEY_DERIVATION_POS)
#define PSA_ENTROPY_INJECT_POS (14UL)
#define PSA_ENTROPY_INJECT (1UL << PSA_ENTROPY_INJECT_POS)

#define CRYPTO_SRV_WAIT_ANY_SID_MSK (\
    PSA_CRYPTO_INIT | \
    PSA_MAC | \
    PSA_HASH | \
    PSA_ASYMMETRIC | \
    PSA_SYMMETRIC | \
    PSA_AEAD | \
    PSA_KEY_MNG | \
    PSA_RNG | \
    PSA_CRYPTO_FREE | \
    PSA_KEY_DERIVATION | \
    PSA_ENTROPY_INJECT)


/* -----------------------------------------------------------------------------
 * PLATFORM defines
 * -------------------------------------------------------------------------- */
#define PLATFORM_ID 8

#define PLATFORM_ROT_SRV_COUNT (3UL)
#define PLATFORM_EXT_ROT_SRV_COUNT (1UL)


#define PLATFORM_WAIT_ANY_IRQ_MSK (0)

#define PSA_PLATFORM_LC_GET_MSK_POS (4UL)
#define PSA_PLATFORM_LC_GET_MSK (1UL << PSA_PLATFORM_LC_GET_MSK_POS)
#define PSA_PLATFORM_LC_SET_MSK_POS (5UL)
#define PSA_PLATFORM_LC_SET_MSK (1UL << PSA_PLATFORM_LC_SET_MSK_POS)
#define PSA_PLATFORM_SYSTEM_RESET_MSK_POS (6UL)
#define PSA_PLATFORM_SYSTEM_RESET_MSK (1UL << PSA_PLATFORM_SYSTEM_RESET_MSK_POS)

#define PLATFORM_WAIT_ANY_SID_MSK (\
    PSA_PLATFORM_LC_GET_MSK | \
    PSA_PLATFORM_LC_SET_MSK | \
    PSA_PLATFORM_SYSTEM_RESET_MSK)


/* -----------------------------------------------------------------------------
 * ITS defines
 * -------------------------------------------------------------------------- */
#define ITS_ID 10

#define ITS_ROT_SRV_COUNT (5UL)
#define ITS_EXT_ROT_SRV_COUNT (0UL)


#define ITS_WAIT_ANY_IRQ_MSK (0)

#define PSA_ITS_GET_MSK_POS (4UL)
#define PSA_ITS_GET_MSK (1UL << PSA_ITS_GET_MSK_POS)
#define PSA_ITS_SET_MSK_POS (5UL)
#define PSA_ITS_SET_MSK (1UL << PSA_ITS_SET_MSK_POS)
#define PSA_ITS_INFO_MSK_POS (6UL)
#define PSA_ITS_INFO_MSK (1UL << PSA_ITS_INFO_MSK_POS)
#define PSA_ITS_REMOVE_MSK_POS (7UL)
#define PSA_ITS_REMOVE_MSK (1UL << PSA_ITS_REMOVE_MSK_POS)
#define PSA_ITS_RESET_MSK_POS (8UL)
#define PSA_ITS_RESET_MSK (1UL << PSA_ITS_RESET_MSK_POS)

#define ITS_WAIT_ANY_SID_MSK (\
    PSA_ITS_GET_MSK | \
    PSA_ITS_SET_MSK | \
    PSA_ITS_INFO_MSK | \
    PSA_ITS_REMOVE_MSK | \
    PSA_ITS_RESET_MSK)



/****************** Test Partitions *******************************************/

#ifdef USE_PSA_TEST_PARTITIONS

#ifdef USE_CRYPTO_ACL_TEST
/* -----------------------------------------------------------------------------
 * CRYPTO_ACL_TEST defines
 * -------------------------------------------------------------------------- */
#define CRYPTO_ACL_TEST_ID 128

#define CRYPTO_ACL_TEST_ROT_SRV_COUNT (6UL)
#define CRYPTO_ACL_TEST_EXT_ROT_SRV_COUNT (1UL)


#define CRYPTO_ACL_TEST_WAIT_ANY_IRQ_MSK (0)

#define CRYPTO_GENERATE_KEY_MSK_POS (4UL)
#define CRYPTO_GENERATE_KEY_MSK (1UL << CRYPTO_GENERATE_KEY_MSK_POS)
#define CRYPTO_OPEN_KEY_MSK_POS (5UL)
#define CRYPTO_OPEN_KEY_MSK (1UL << CRYPTO_OPEN_KEY_MSK_POS)
#define CRYPTO_CLOSE_KEY_MSK_POS (6UL)
#define CRYPTO_CLOSE_KEY_MSK (1UL << CRYPTO_CLOSE_KEY_MSK_POS)
#define CRYPTO_DESTROY_KEY_MSK_POS (7UL)
#define CRYPTO_DESTROY_KEY_MSK (1UL << CRYPTO_DESTROY_KEY_MSK_POS)
#define CRYPTO_GET_KEY_ATTRIBUTES_MSK_POS (8UL)
#define CRYPTO_GET_KEY_ATTRIBUTES_MSK (1UL << CRYPTO_GET_KEY_ATTRIBUTES_MSK_POS)
#define CRYPTO_IMPORT_KEY_MSK_POS (9UL)
#define CRYPTO_IMPORT_KEY_MSK (1UL << CRYPTO_IMPORT_KEY_MSK_POS)

#define CRYPTO_ACL_TEST_WAIT_ANY_SID_MSK (\
    CRYPTO_GENERATE_KEY_MSK | \
    CRYPTO_OPEN_KEY_MSK | \
    CRYPTO_CLOSE_KEY_MSK | \
    CRYPTO_DESTROY_KEY_MSK | \
    CRYPTO_GET_KEY_ATTRIBUTES_MSK | \
    CRYPTO_IMPORT_KEY_MSK)


#endif  // USE_CRYPTO_ACL_TEST

#ifdef USE_CLIENT_TESTS_PART1
/* -----------------------------------------------------------------------------
 * CLIENT_TESTS_PART1 defines
 * -------------------------------------------------------------------------- */
#define CLIENT_TESTS_PART1_ID 1

#define CLIENT_TESTS_PART1_ROT_SRV_COUNT (3UL)
#define CLIENT_TESTS_PART1_EXT_ROT_SRV_COUNT (0UL)


#define CLIENT_TESTS_PART1_WAIT_ANY_IRQ_MSK (0)

#define PART1_ROT_SRV1_MSK_POS (4UL)
#define PART1_ROT_SRV1_MSK (1UL << PART1_ROT_SRV1_MSK_POS)
#define DROP_CONN_MSK_POS (5UL)
#define DROP_CONN_MSK (1UL << DROP_CONN_MSK_POS)
#define SECURE_CLIENTS_ONLY_MSK_POS (6UL)
#define SECURE_CLIENTS_ONLY_MSK (1UL << SECURE_CLIENTS_ONLY_MSK_POS)

#define CLIENT_TESTS_PART1_WAIT_ANY_SID_MSK (\
    PART1_ROT_SRV1_MSK | \
    DROP_CONN_MSK | \
    SECURE_CLIENTS_ONLY_MSK)


#endif  // USE_CLIENT_TESTS_PART1

#ifdef USE_SERVER_TESTS_PART1
/* -----------------------------------------------------------------------------
 * SERVER_TESTS_PART1 defines
 * -------------------------------------------------------------------------- */
#define SERVER_TESTS_PART1_ID 2

#define SERVER_TESTS_PART1_ROT_SRV_COUNT (2UL)
#define SERVER_TESTS_PART1_EXT_ROT_SRV_COUNT (2UL)


#define SERVER_TESTS_PART1_WAIT_ANY_IRQ_MSK (0)

#define CONTROL_MSK_POS (4UL)
#define CONTROL_MSK (1UL << CONTROL_MSK_POS)
#define TEST_MSK_POS (5UL)
#define TEST_MSK (1UL << TEST_MSK_POS)

#define SERVER_TESTS_PART1_WAIT_ANY_SID_MSK (\
    CONTROL_MSK | \
    TEST_MSK)


#endif  // USE_SERVER_TESTS_PART1

#ifdef USE_SERVER_TESTS_PART2
/* -----------------------------------------------------------------------------
 * SERVER_TESTS_PART2 defines
 * -------------------------------------------------------------------------- */
#define SERVER_TESTS_PART2_ID 3

#define SERVER_TESTS_PART2_ROT_SRV_COUNT (2UL)
#define SERVER_TESTS_PART2_EXT_ROT_SRV_COUNT (0UL)


#define SERVER_TESTS_PART2_WAIT_ANY_IRQ_MSK (0)

#define ROT_SRV_REVERSE_MSK_POS (4UL)
#define ROT_SRV_REVERSE_MSK (1UL << ROT_SRV_REVERSE_MSK_POS)
#define ROT_SRV_DB_TST_MSK_POS (5UL)
#define ROT_SRV_DB_TST_MSK (1UL << ROT_SRV_DB_TST_MSK_POS)

#define SERVER_TESTS_PART2_WAIT_ANY_SID_MSK (\
    ROT_SRV_REVERSE_MSK | \
    ROT_SRV_DB_TST_MSK)


#endif  // USE_SERVER_TESTS_PART2

#ifdef USE_SMOKE_TESTS_PART1
/* -----------------------------------------------------------------------------
 * SMOKE_TESTS_PART1 defines
 * -------------------------------------------------------------------------- */
#define SMOKE_TESTS_PART1_ID 4

#define SMOKE_TESTS_PART1_ROT_SRV_COUNT (1UL)
#define SMOKE_TESTS_PART1_EXT_ROT_SRV_COUNT (0UL)


#define SMOKE_TESTS_PART1_WAIT_ANY_IRQ_MSK (0)

#define ROT_SRV1_MSK_POS (4UL)
#define ROT_SRV1_MSK (1UL << ROT_SRV1_MSK_POS)

#define SMOKE_TESTS_PART1_WAIT_ANY_SID_MSK (\
    ROT_SRV1_MSK)


#endif  // USE_SMOKE_TESTS_PART1


#endif  // USE_PSA_TEST_PARTITIONS

#endif // __MBED_SPM_PARTITIONS_H___
