# PSA Internal Trusted Storage Testcase checklist

## Requirements for Storage Test Suite

Following are the requirements of the Storage Test Suite. <br />

1. Unless described in this document, any behaviour that is defined as IMPLEMENTATION_DEFINED in PSA Storage API document is not verified in this document. <br />
2. Storage Test Cases use UID value starting from 1 onwards. These UID needs to be free for successfull test execution.<br />
3. UID values 1 and 2 are reserved as WRITE_ONCE UID.These UID can't be free from testcase. Make sure these are free.<br />


| Test      | Return Value                         | API Verified                                                                 | Test Algorithm                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     | UID Usage                                                                                                                                                                                        |
|-----------|--------------------------------------|------------------------------------------------------------------------------|--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
| test_s001 | PSA_ITS_ERROR_UID_NOT_FOUND          | psa_its_get<br />psa_its_get_info <br />psa_its_remove<br />                 | 1. Call get API with UID for which no UID/Data pair is created<br />2. Call get_info API for which no UID/Data pair is created<br />3. Call remove API for which no UID/Data pair is created<br />4. Set valid  UID/Data pair with uid1<br />5. Set one more set of UID/Data pair, with different uid, than previous<br />6. Remove the uid of step 4.<br />7. Call get API for  removed UID/data pair<br />8. Call get_info API for  removed UID/Data pair<br />9. Call remove API for  removed UID/Data pair<br />10. Set valid UID/Data pair<br />11. Call get API for different uid , then created<br />12. Call get_info API for different uid, then created<br />13. Call remove API for different uid, then created<br />14. Remove the created UID/Data pair.<br />15. Remove the stray uid.<br />                                                                                                         | UID value used are 5,6,7                                                                                                                     |
| test_s002 | PSA_ITS_ERROR_WRITE_ONCE             | psa_its_set<br />psa_its_remove<br />                                        | 1.  Set valid UID/data value pair , with create flag value none.2. Call get and get_info API to validate the data, attributes associated with data<br />3. Call set API again with same uid and create flag  PSA_PS_WRITE_ONCE_FLAG<br />4. Call get and get_info API to validate the data, attributes associated with data is not changed after second set operation<br />5. try to remove the UID/data pair.<br />6. Create new UID/data value pair, with create flag PSA_PS_WRITE_ONCE_FLAG<br />7. Try to remove the created UID.<br />8. Call get and get_info API to validate the data, attributes associated with data<br />9. Again call SET with same UID , create flag PSA_PS_WRITE_ONCE_FLAG but different data length<br />10. Try to remove the UID, PSA_ITS_ERROR_WRITE_ONCE error should be returned<br />11. Call get and get_info API to validate the data, attributes associated with data<br /> | UID value used are 1 and 2                                                                                                                                                                     |
| test_s003 | PSA_ITS_ERROR_INSUFFICIENT_SPACE     | psa_its_set<br />                                                            | 1. Create UID/data pairs, with data_len 256 bytes. Do this with incrementing uid values till we have INSUFFICENT_SPACE.<br />2. Remove all the UID/data pairs created.<br />3. Repeat the steps once more, to check all previous uid are removed successfully<br />                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | UID value starts from 5 and keep on incrementing till all space is exhausted                                                                                                                    |
| test_s004 | PSA_ITS_SUCCESS                      | psa_its_set<br />psa_its_get<br />psa_its_get_info<br />psa_its_remove<br /> | 1. Set a valid uid/data pair<br />2. Validate the data using get api<br />3. Change the data length to half of previous.<br />4. Call GET api with original data length , error should be returned and also the return buffer should be empty<br />5. Call GET api with correct data_len and validate the data received.<br />6. Check old data cannot be accessed.<br />7. Call REMOVE api to delete the UID/data pair<br />                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      | UID value used is 5                                                                                                                                                                            |
| test_s005 | PSA_ITS_SUCCESS                      | psa_its_set<br />psa_its_get<br />psa_its_get_info<br />psa_its_remove<br /> | 1. Set valid UID/data pair with varying uid and data_len <br />2. Call GET api and validate the set data<br />3. Call GET info api and validate the data attributes<br />4. Call REMOVE api to delete the UID/data pair<br />                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      | UID value used are 4                                                                                                                           |
| test_s006 | PSA_ITS_ERROR_FLAGS_NOT_SUPPORTED    | psa_its_set<br />                                                            | 1.  Call the SET_INFO with minimum flag value to max flag value <br />2. Call GET_INFO api and validate the flag value<br />3. Remove the uid/data pair<br />                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       | UID value used is 5                                                                                                                          |
| test_s007 | PSA_ITS_ERROR_INCORRECT_SIZE | psa_its_set<br />                                                            | 1. Create valid uid/data pair. <br />2. Increase the length of storage.<br />3. Try to access the old length using get api.<br />4. Try to access with valid length less than stored size.<br />5. Decrease the length of storage.<br />6. Try to access the old length.<br />7. Remove the uid<br />                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | UID value used is 5                                                                                                                       |
| test_s008 | PSA_ITS_ERROR_OFFSET_INVALID         | psa_its_get<br />                                                            | 1. Set valid UID/data pair<br />2. Call GET api with valid offset and offset + data_len equal to stored data size.<br />3. Call GET api with valid offset and offset + data_len less than stored data size.<br />4. Call get api with invalid offset.<br />5. Call get api with zero offset , but data len greater than data size.<br />6. Remove the uid.<br />                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | UID value used is  5 |
| test_s009 | PSA_ITS_SUCCESS            | psa_its_get<br />psa_its_set<br />psa_its_get_info<br />                     | 1. Call the SET API with NULL pointer and data_len zero <br />2. Validate using get_info api storage should be present.<br />3. Call get API with NULL pointer.<br />4. Remove the UID.<br />5. Call get_info API to validate storage is removed.<br />6. Set storage entity with valid write_buffer , but length zero.<br />7. Call get_info API to validate storage attributes.<br />8. Call get_info api with NULL pointer and valid uid.<br />9. Remove the uid<br />                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    | UID value used is 5 <br />                                                                                                                                                                     |
| test_s010 | PSA_ITS_ERROR_STORAGE_FAILURE <br />            | psa_its_set<br />                     | 1. Call the SET API with UID value 0.<br />2. Check that storage creation fails.<br /> | UID value used is 0 <br />                                                                                                                                                                     |

## License
Arm PSA test suite is distributed under Apache v2.0 License.

--------------

*Copyright (c) 2019, Arm Limited and Contributors. All rights reserved.*
