#if defined(TARGET_LPC1768)

void
iSerial::enable_uart_irq(void)
{
    switch(tx) {
        case USBTX:
            NVIC_EnableIRQ(UART2_IRQn);
            break;
        case p9:
            NVIC_EnableIRQ(UART1_IRQn);
            break;
        case p13:
            NVIC_EnableIRQ(UART3_IRQn);
            break;
        case p28:
            NVIC_EnableIRQ(UART0_IRQn);
            break;
    }
}

void
iSerial::disable_uart_irq(void)
{
    switch(tx) {
        case USBTX:
            NVIC_DisableIRQ(UART2_IRQn);
            break;
        case p9:
            NVIC_DisableIRQ(UART1_IRQn);
            break;
        case p13:
            NVIC_DisableIRQ(UART3_IRQn);
            break;
        case p28:
            NVIC_DisableIRQ(UART0_IRQn);
            break;
    }
}

#endif
