//
//  iSerial.h ... Serial Driver with Interrupt Rec/Send
//
//  Copyright 2012  Yoji KURODA
//
//  2009.11.13 ... Originally written by Y.Kuroda for Renesas H83664
//  2012.08.31 ... Code convert for mbed in C++
//  2015.01.02 ... Added other mbed code by JH1PJL
//  2016.11.11 ... Added STM32F746 with durty solution
//
#ifndef _ISERIAL_H
#define _ISERIAL_H

#include <string.h>
#include "RingBuffer.h"

/** iSerial class
 *
 * @code
 * #include "mbed.h"
 * #include "iSerial.h"
 *
 * iSerial     pc(USBTX, USBRX, 32, 1024);
 * 
 * int main() {
 * uint32_t n = 0;
 *    
 *     while(true){
 *          pc.printf("count n=%d", ++n);
 *          wait(1.0);
 *     } 
 * }
 *  @endcode
 */

class iSerial : public Serial {
  protected:

    PinName tx;
    PinName rx;
    const int txbufsize;
    const int rxbufsize;
    RingBuffer txbuf;
    RingBuffer rxbuf;
    char* str;

    void tx_handler(void);
    void rx_handler(void);
    void enable_uart_irq(void);
    void disable_uart_irq(void);

  public:

    enum TERMINL_CODES { CR=0x0D, LF=0x0A };

    /** Configure pin and buffer size
      * @param pin assign TX, RX the buffer size for TX, RX
      */
    iSerial(PinName _tx, PinName _rx, int _txbufsize=100, int _rxbufsize=100);
    
    virtual ~iSerial();
    
    short int putstr(const char* s);
    int readable(void);
    int getc(void);
    void putc(short ch);
    short int puts(const char* s);
    //void printf();
    char* printf(const char* format, ...);

    void flush(void);
};

#endif    /* _ISERIAL_H */
