/*
 * mbed Library program
 *      Frequency Counter Hardware relataed program
 *
 * Copyright (c) 2014,'15,'20 Kenji Arai / JH1PJL
 *      http://www7b.biglobe.ne.jp/~kenjia/
 *      https://os.mbed.com/users/kenjiArai/
 *          Created: October   18th, 2014
 *          Revised: January   13th, 2020
 *
 */

#ifndef        MBED_F_COUNTER
#define        MBED_F_COUNTER

#include "mbed.h"

/*
    CAUTION: Direct access to the CPU Timer module!!
        No way to change pin asｓign and timer module
    Tested on Nucleo F401RE, F411RE & F446RE
    Tested on mbed-os5.15.0 & mbed-2.0.165

    Input pin selection -> Only PA0, PA1, PB3 
 */

/** Frequency Counter
 *
 * @code
 * #include "mbed.h"
 * #include "freq_counter.h"
 * 
 * F_COUNTER fc(PA_0);    // for F401,F411 & F446
 *
 * int main() {
 *   uint32_t frequency = 0;
 *
 *   while(true) {
 *      freqency = fc.read_frequency(1.0);  // gate time: 1 sec
 *      printf("%d [Hz]", frequency);
 *   }
 * }
 * @endcode
 */

class F_COUNTER
{
public:
    /** Configure data pin
      * @param frequency counter input pin
      * @param gate time (seconds)
      */
    F_COUNTER(PinName f_in, float gate_time = 1.0f);

    /** Read measured frequency
      * @param none
      * @return measured frequency (minus = input pin is incorrect)
      */
    int32_t read_frequency(void);

    /** Set new gate time
      * @param new gate time (seconds)
      * @return none
      */
    void set_gate_time(float gat_time);

    /** Read input assign number
      * @param none
      * @return Pin number
      */
    uint32_t read_pin();

protected:
    DigitalIn _pin;
    Ticker   _t;

    void initialize(void);
    void irq(void);

private:
    uint32_t pin_num;
    float gt;
    int32_t freq_raw;
    bool new_input;

};

#endif  //  MBED_F_COUNTER
