/*
 * e-Paper control program
 *
 * Copyright (c) 2019 Kenji Arai / JH1PJL
 *  http://www.page.sannet.ne.jp/kenjia/index.html
 *  http://mbed.org/users/kenjiArai/
 *      Created:    April     27th, 2019
 *      Revised:    August    29th, 2019
 *
 *  Tested on nRF52-DK with mbed-os5.13.3
 *
 *  Refrence software
 *  https://github.com/waveshare/e-Paper
 *  https://os.mbed.com/users/imachooon/code/epd1in54/
 *          Thanks imamura-san
 *
 *  Technical documents
 *  https://www.waveshare.com/wiki/2.13inch_e-Paper_HAT_(B)
 *
 *  Product
 *  http://akizukidenshi.com/catalog/g/gP-13757/
 *  https://www.waveshare.com/2.13inch-e-paper-hat-b.htm
 */

//  Include --------------------------------------------------------------------
#include "mbed.h"
#include "epd4in2b.h"
#include "epdpaint.h"

//  Definition -----------------------------------------------------------------
#define COLORED     0
#define UNCOLORED   1

#define DEBUG  0

#if DEBUG
#define DBG(...)    pc.printf(__VA_ARGS__)
#else
#define DBG(...)    {;}
#endif

//  Constructor ----------------------------------------------------------------
#if defined(TARGET_NRF52832)
//             mosi,miso,  sclk,    cs,    dc,   rst, busy,   pwr
Epd epd = Epd(P0_23,  NC, P0_25, P0_22, P0_19, P0_20, P0_2, P0_11);
DigitalIn button1(P0_13);
#elif defined(TARGET_NRF52840)
//             mosi,miso,  sclk,    cs,    dc,   rst, busy,   pwr
Epd epd = Epd(P1_13,  NC, P1_15, P1_12, P1_10, P1_11, P0_2, P1_1);
DigitalIn button1(P0_11);
#else
#error "Only for nRF52840 & nRF52832 CPU"
#endif
Serial pc(USBTX, USBRX);
Timer t;

//  RAM ------------------------------------------------------------------------
uint8_t image[EPD_HEIGHT*(EPD_WIDTH/8 + 1)];

//  ROM / Constant data --------------------------------------------------------

//  Function prototypes --------------------------------------------------------
extern void time_enter_mode(void);

//------------------------------------------------------------------------------
//  Control Program
//------------------------------------------------------------------------------
void set_p14_for_detect()
{
    NRF_GPIO->PIN_CNF[14] = 3UL << 16;  // BTN2
}

int main()
{
    time_t seconds;
    char buf[32];

    DBG("line:%d\r\n", __LINE__);
    t.reset();
    t.start();
    if (button1 == 0) {  // USER BUTTON1 is on then go to time enter mode
        time_enter_mode();
    }
    epd.PwrOn();
    ThisThread::sleep_for(10);
    DBG("line:%d\r\n", __LINE__);
    seconds = time(NULL);   // read current time
    if (epd.Init() != 0) {  // initialize e-Paper control program
        printf("e-Paper init failed");
        return -1;
    }
    DBG("line:%d\r\n", __LINE__);
    epd.ClearFrame();
    ThisThread::sleep_for(200);
    Paint paint(image, EPD_WIDTH, EPD_HEIGHT);
    paint.Clear(UNCOLORED);
    //paint.SetRotate(ROTATE_90);
    DBG("line:%d\r\n", __LINE__);
    paint.DrawStringAt(0,  4,  "123456789012345678901234567890123456789012345678901234567890",
                       &Font12, COLORED);
    paint.DrawStringAt(0, 16, "  Waveshare 4.2 e-Paper WBY",
                       &Font12, COLORED);
    paint.DrawStringAt(0, 30, "Run on mbed-os5.13.4 Latest Revision",
                       &Font16, COLORED);
    paint.DrawStringAt(0, 45, "   tested on Nordic nRF52-DK & nRF52840-DK",
                       &Font12, COLORED);
    paint.DrawStringAt(0, 58, "         by JH1PJL Kenji Arai",
                       &Font12, COLORED);
    DBG("line:%d\r\n", __LINE__);
    strftime(buf, 30, "'%y-%m-%d %H:%M", localtime(&seconds));
    paint.DrawStringAt(0, 90, buf, &Font16, COLORED);
    strftime(buf, 30, " %B %d,'%y, %H:%M:%S", localtime(&seconds));
    pc.puts(buf);
    paint.DrawStringAt(0, 110, " e-Paper 4.2inch",
                       &Font8, COLORED);
    paint.DrawStringAt(0, 120, " e-Paper 4.2inch",
                       &Font12, COLORED);
    paint.DrawStringAt(0, 135, " e-Paper 4.2inch",
                       &Font16, COLORED);
    paint.DrawStringAt(0, 150, " e-Paper 4.2inch",
                       &Font20, COLORED);
    paint.DrawStringAt(0, 175, " e-Paper 4.2inch",
                       &Font24, COLORED);
    paint.DrawStringAt(0, 200, " e-Paper 4.2inch",
                       &Font2829, COLORED);
    paint.DrawStringAt(0, 230, " e-Paper 4.2inch",
                       &Font4040, COLORED);

    epd.SetPartialWindowBlack(paint.GetImage(), 0, 8,
                              paint.GetWidth(), paint.GetHeight());
    paint.Clear(UNCOLORED);
    //paint.SetRotate(ROTATE_90);
    paint.DrawFilledRectangle(0, 28, 400, 29, COLORED);
    paint.DrawFilledRectangle(0, 43, 400, 44, COLORED);
    paint.DrawFilledRectangle(0, 74, 350, 80, COLORED);
    paint.DrawFilledCircle(350, 76, 30, COLORED);
    epd.SetPartialWindowRed(paint.GetImage(), 0, 8,
                               paint.GetWidth(), paint.GetHeight());
    epd.DisplayFrame();
    epd.Sleep();
    epd.PwrOff();
    ThisThread::sleep_for(1000);
    pc.printf("  Display + Refresh time = %5.1f Sec\r\n", t.read());
    ThisThread::sleep_for(10);
    set_p14_for_detect();
    NRF_POWER->SYSTEMOFF = 1;
    while(true) {
        ;
    }
    system_reset(); // restart
}
