/*
 * e-Paper control program
 *
 * Copyright (c) 2019 Kenji Arai / JH1PJL
 *  http://www.page.sannet.ne.jp/kenjia/index.html
 *  http://mbed.org/users/kenjiArai/
 *      Created:    April     27th, 2019
 *      Revised:    June      29th, 2019
 *
 *  Tested on Nucleo-F446RE with mbed-os5.12.2
 *
 *  Refrence software
 *  https://github.com/waveshare/e-Paper
 *  https://os.mbed.com/users/imachooon/code/epd1in54/
 *          Thanks imamura-san
 *
 *  Technical documents
 *  https://www.waveshare.com/wiki/2.13inch_e-Paper_HAT_(B)
 *
 *  Product
 *  http://akizukidenshi.com/catalog/g/gP-13757/
 *  https://www.waveshare.com/2.13inch-e-paper-hat-b.htm
 */

//  Include --------------------------------------------------------------------
#include "mbed.h"
#include "epd2in13c.h"
#include "epdpaint.h"

//  Definition -----------------------------------------------------------------
#define COLORED     0
#define UNCOLORED   1

//  Constructor ----------------------------------------------------------------
//  3.3V, GND, DIN,     ,  CLK,  CS, DC, RST, BUSY,   <- 2.13inch e-Paper pin   
//            mosi, miso, sclk,  cs, dc, rst, busy, pwr
Epd epd = Epd(  D4,   NC,   D3, D10, D9,  D8,   D7,  NC);
DigitalOut myled(LED1);
DigitalIn  sw(USER_BUTTON);
Serial pc(USBTX, USBRX);
Timer t;

//  RAM ------------------------------------------------------------------------
uint8_t image[EPD_HEIGHT*(EPD_WIDTH/8 + 1)];

//  ROM / Constant data --------------------------------------------------------

//  Function prototypes --------------------------------------------------------
extern void time_enter_mode(void);

//------------------------------------------------------------------------------
//  Control Program
//------------------------------------------------------------------------------
int main()
{
    time_t seconds;
    char buf[32];

    t.reset();
    t.start();
    if (sw == 0) {  // USER BUTTON is on then go to time enter mode
        time_enter_mode();
    }
    seconds = time(NULL);   // read current time
    if (epd.Init() != 0) {  // initialize e-Paper control program
        printf("e-Paper init failed");
        return -1;
    }
    epd.ClearFrame();
    ThisThread::sleep_for(200);
    Paint paint(image, EPD_WIDTH, EPD_HEIGHT);
    paint.Clear(UNCOLORED);
    paint.SetRotate(ROTATE_90);
    paint.DrawStringAt(0,  4,  "12345678901234567890123456789",
                       &Font12, COLORED);
    paint.DrawStringAt(0, 16, "Waveshare 2.13 e-Paper WBY",
                       &Font12, COLORED);
    paint.DrawStringAt(0, 30, "Run on mbed-os5.13",
                       &Font16, COLORED);
    paint.DrawStringAt(0, 42, "   tested on Nucleo-F446RE",
                       &Font12, COLORED);
    paint.DrawStringAt(0, 54, "         by JH1PJL ",
                       &Font12, COLORED);
    strftime(buf, 30, "'%y-%m-%d %H:%M", localtime(&seconds));
    paint.DrawStringAt(0, 90, buf, &Font16, COLORED);
    strftime(buf, 30, " %B %d,'%y, %H:%M:%S", localtime(&seconds));
    pc.puts(buf);
    epd.SetPartialWindowBlack(paint.GetImage(), 0, 8,
                              paint.GetWidth(), paint.GetHeight());
    paint.Clear(UNCOLORED);
    paint.SetRotate(ROTATE_90);
    paint.DrawFilledRectangle(0, 74, 180, 80, COLORED);
    paint.DrawFilledCircle(180, 76, 18, COLORED);
    epd.SetPartialWindowYellow(paint.GetImage(), 0, 8,
                               paint.GetWidth(), paint.GetHeight());
    epd.DisplayFrame();
    epd.Sleep();
    pc.printf("  Display + Refresh time = %5.1f Sec\r\n", t.read());
    ThisThread::sleep_for((1000 * 60 * 5) - t.read_ms());   // sleep 5 minutes
    system_reset(); // restart
}
