/*
 * mbed Application program
 *
 *  Copyright (c) 2010-2015 Kenji Arai / JH1PJL
 *  http://www.page.sannet.ne.jp/kenjia/index.html
 *  http://mbed.org/users/kenjiArai/
 *      Created:  May  	    15th, 2010
 *		Spareted: June		25th, 2014		mon() & mon_hw()
 *		Ported:   September 22nd, 2014		from L152RE, LP1114
 *      changed:  October   15th, 2014		mon.cpp to debug_xxx.cpp
 *      Revised:  April     25th, 2015		Bug fix ('o' command) pointed out by Topi Makinen
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED,
 * INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE
 * AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
 * DAMAGES OR OTHER  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

#if defined(TARGET_NUCLEO_F401RE) || defined(TARGET_NUCLEO_F411RE) || defined(TARGET_NUCLEO_L152RE)

//  Include ---------------------------------------------------------------------------------------
#include "mbed.h"
#include "debug_common.h"
#include "CheckRTC.h"

//  Object ----------------------------------------------------------------------------------------
DigitalOut myled(LED1);
DigitalIn usr_sw(PC_13);

//  Definition ------------------------------------------------------------------------------------

//  RAM -------------------------------------------------------------------------------------------

//  ROM / Constant data ---------------------------------------------------------------------------

//  Function prototypes ---------------------------------------------------------------------------
extern void cpu_inf( char *ptr );
extern void port_mco1_mco2_set(uint8_t n);
extern void port_mco1_mco2_recover(void);

//-------------------------------------------------------------------------------------------------
//  Control Program
//-------------------------------------------------------------------------------------------------
//  Help Massage
void msg_hlp (void)
{
    PRINTF(mon_msg);
    put_rn();
    PRINTF("1 - goto step1 -> no connection all pins");
    put_rn();
    PRINTF("2 - goto step2 -> connects pin_x and pin_y");
    put_rn();
    PRINTF("t - Check and set RTC");
    put_rn();
    PRINTF("x - Goto HW monitor");
    put_rn();
    PRINTF("q - Return to main");
    put_rn();
}

// ---------- Program starts here! ---------------------------------------------------------------
void debug_interface(void)
{
    char c;
    char *ptr;
    uint8_t quitflag;

    BAUD(BAUD_RATE);
    put_rn();
    put_rn();
    PRINTF("%s [Help:'?' key]", mon_msg);
    put_rn();
    CheckRTC();
    for (;;) {
        put_r();
        PUTC('>');
        ptr = linebuf;
        get_line(ptr, sizeof(linebuf));
        switch (*ptr++) {
                //---------------------------------------------------------------------------------
                //  Debug Step1
                //---------------------------------------------------------------------------------
            case '1' :
                put_r();
                PRINTF("Enter Step1: no connection all pins");
                put_rn();
                quitflag = 0;
                for (; quitflag != 0xff;) {
                    PRINTF("1>");
                    ptr = linebuf;
                    get_line(ptr, buf_size);
                    put_r();
                    switch(*ptr++) {
                        case 'l' :
                            myled = 1;
                            PRINTF("Is LED on? -> enter y/n");
                            put_rn();
                            c = GETC();
                            if (c == 'y') {
                                PRINTF("Okay");
                            } else {
                                PRINTF("Are you sure? Check again!");
                                for (c = 0; c < 30; c++) {
                                    myled = !myled;
                                    wait(0.2);
                                }
                                myled = 1;
                                put_rn();
                                PRINTF("Is LED on? -> enter y/n");
                                put_rn();
                                c = GETC();
                                if (c == 'y') {
                                    PRINTF("Looks okay");
                                } else {
                                    PRINTF("Please check LED line");
                                }
                            }
                            put_rn();
                            myled = 0;
                            break;
                        case 'b' :
                            PRINTF("Please push [USER] button -> You can see LED on if you push a button");
                            put_rn();
                            PRINTF("Hit any key to exit");
                            while (true) {
                                if (usr_sw == 0) {
                                    myled = 1;
                                } else {
                                    myled = 0;
                                }
                                if (READABLE()) {
                                    break;
                                }
                            }
                            GETC();
                            put_rn();
                            break;
                        case 's' :
                            PRINTF("----- CPU CLOCK Information -----");
                            put_rn();
                            c = 'f';
                            cpu_inf(&c);
                            PRINTF("----- CPU TYPE Information ------");
                            put_rn();
                            c = 'c';
                            cpu_inf(&c);
                            break;
#if defined(TARGET_NUCLEO_F401RE) || defined(TARGET_NUCLEO_F411RE)
                        case 'o' : // Bug fix on April 25, 2015
                            PRINTF("----- CPU CLOCK output from PA8 & PC9 -----");
                            put_rn();
                            PRINTF("Please check that both PA8 & PC9 ");
                            PRINTF("are no connection with any peripheral I/O!!");
                            put_rn();
                            PRINTF("Are you okay? [y/n]");
                            put_rn();
                            c = GETC();
                            if (c == 'y') {
                                port_mco1_mco2_set(0);
                                port_mco1_mco2_set(1);
                                PRINTF("Please measure frequency at PA8 & PC9 pins");
                                put_rn();
                                PRINTF("PA8: HSE/4");
                                put_rn();
                                PRINTF("PC9: SYSCLK/4");
                                put_rn();
                                PRINTF("Change requency (Please hit any key)");
                                put_rn();
								c = GETC();
								port_mco1_mco2_set(2);
                                PRINTF("PA8: HSE/1");
                                put_rn();
                                PRINTF("PC9: SYSCLK/2");
                                put_rn();
                                PRINTF("If you would like to finish, hit anykey");
                                put_rn();
                                c = GETC();
                                port_mco1_mco2_recover();
                                PRINTF("End");
                                put_rn();
                            }
                            break;
#endif      // defined(TARGET_NUCLEO_F401RE) 
                        case '?' :
                            PRINTF("l - Check LED");
                            put_rn();
                            PRINTF("b - Check button");
                            put_rn();
                            PRINTF("s - CPU system info & clock");
                            put_rn();
#if defined(TARGET_NUCLEO_F401RE) || defined(TARGET_NUCLEO_F411RE)
                            PRINTF("o - CPU clock output");
                            put_rn();
#endif      // defined(TARGET_NUCLEO_F401RE)                             
                            PRINTF("q - Return to all mode");
                            put_rn();
                            PRINTF("? - You know this");
                            put_rn();
                            break;
                        case 'q' :        // quit
                            PRINTF("Back to all mode");
                            quitflag = 0xff;
                            break;
                        default:
                            PUTC('?');
                            put_rn();
                    }
                }
                put_rn();
                break;
                //---------------------------------------------------------------------------------
                //  check and set RTC
                //---------------------------------------------------------------------------------
            case 't' :
                put_r();
                chk_and_set_time(ptr);
                break;
                //---------------------------------------------------------------------------------
                //  help
                //---------------------------------------------------------------------------------
            case '?' :
                put_r();
                msg_hlp();
                break;
                //---------------------------------------------------------------------------------
                //  Go to special command
                //---------------------------------------------------------------------------------
            case 'x' :
                mon_hw();
                PRINTF("->Came back monitor\r\n");
                break;
                //---------------------------------------------------------------------------------
                //  Go back to main()
                //---------------------------------------------------------------------------------
            case 'q' :        // Quit
                PRINTF("\rReturn to main\r\n");
                //PRINTF("cannot control anymore from here\r\n");
                return;
                //---------------------------------------------------------------------------------
                //    no support
                //---------------------------------------------------------------------------------
            default:
                put_r();
                PUTC('?');
                put_rn();
                break;
        }
    }
}

#endif // defined(TARGET_NUCLEO_F401RE) || defined(TARGET_NUCLEO_L152RE)
