/*
 * mbed Application program
 *
 *  Copyright (c) 2010-2014 Kenji Arai / JH1PJL
 *  http://www.page.sannet.ne.jp/kenjia/index.html
 *  http://mbed.org/users/kenjiArai/
 *      Created:  May       15th, 2010
 *      Spareted: June      25th, 2014      mon() & mon_hw()
 *      Ported:   September 22nd, 2014      from L152RE, LP1114
 *      changed:  October   15th, 2014      mon.cpp to debug_xxx.cpp
 *      Revised:  Nobember   2nd, 2014
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED,
 * INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE
 * AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
 * DAMAGES OR OTHER  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

#if defined(TARGET_LPC1768)

//  Include ---------------------------------------------------------------------------------------
#include "mbed.h"
#include "debug_common.h"

//  Object ----------------------------------------------------------------------------------------
DigitalOut myled1(LED1);
DigitalOut myled2(LED2);
DigitalOut myled3(LED3);
DigitalOut myled4(LED4);

//  Definition ------------------------------------------------------------------------------------

//  RAM -------------------------------------------------------------------------------------------

//  ROM / Constant data ---------------------------------------------------------------------------

//  Function prototypes ---------------------------------------------------------------------------
extern void cpu_inf (void);

//-------------------------------------------------------------------------------------------------
//  Control Program
//-------------------------------------------------------------------------------------------------
//  Help Massage
void msg_hlp (void)
{
    PRINTF(mon_msg);
    put_rn();
    PRINTF("1 - goto step1 -> no connection all pins");
    put_rn();
    PRINTF("2 - goto step2 -> connects pin_x and pin_y");
    put_rn();
    PRINTF("t - Check and set RTC");
    put_rn();
    PRINTF("x - Goto HW monitor");
    put_rn();
    PRINTF("q - Return to main");
    put_rn();
}

// ---------- Program starts here! ---------------------------------------------------------------
void debug_interface(void)
{
    char c;
    char *ptr;
    uint8_t quitflag;

    BAUD(BAUD_RATE);
    put_rn();
    put_rn();
    PRINTF("%s [Help:'?' key]", mon_msg);
    put_rn();
    get_freq(0);
    for (;;) {
        put_r();
        PUTC('>');
        ptr = linebuf;
        get_line(ptr, sizeof(linebuf));
        switch (*ptr++) {
                //---------------------------------------------------------------------------------
                //  Debug Step1
                //---------------------------------------------------------------------------------
            case '1' :
                put_r();
                PRINTF("Enter Step1: no connection all pins");
                put_rn();
                quitflag = 0;
                for (; quitflag != 0xff;) {
                    PRINTF("1>");
                    ptr = linebuf;
                    get_line(ptr, buf_size);
                    put_r();
                    switch(*ptr++) {
                        case 'l' :
                            myled1 = 1;
                            wait(0.1);
                            myled1 = 0;
                            myled2 = 1;
                            wait(0.1);
                            myled2 = 0;
                            myled3 = 1;
                            wait(0.1);
                            myled3 = 0;
                            myled4 = 1;
                            wait(0.1);
                            myled4 = 0;
                            myled1 = 1;
                            wait(0.2);
                            myled2 = 1;
                            wait(0.2);
                            myled3 = 1;
                            wait(0.2);
                            myled4 = 1;
                            PRINTF("Is LED on? -> enter y/n");
                            put_rn();
                            c = GETC();
                            if (c == 'y') {
                                PRINTF("Okay");
                            } else {
                                PRINTF("Are you sure? Check again!");
                                for (c = 0; c < 10; c++) {
                                    myled1 = !myled1;
                                    wait(0.1);
                                    myled2 = !myled2;
                                    wait(0.1);
                                    myled3 = !myled3;
                                    wait(0.1);
                                    myled4 = !myled4;
                                    wait(0.1);
                                }
                                myled1 = 1;
                                myled2 = 1;
                                myled3 = 1;
                                myled4 = 1;
                                put_rn();
                                PRINTF("Is LED on? -> enter y/n");
                                put_rn();
                                c = GETC();
                                if (c == 'y') {
                                    PRINTF("Looks okay");
                                } else {
                                    PRINTF("Please check LED line");
                                }
                            }
                            put_rn();
                            myled1 = 0;
                            myled2 = 0;
                            myled3 = 0;
                            myled4 = 0;
                            break;
                        case 's' :
                            PRINTF("----- CPU CLOCK Information -----");
                            put_rn();
                            get_freq(1);
                            PRINTF("----- CPU TYPE Information ------");
                            put_rn();
                            cpu_inf();
                            break;
                        case '?' :
                            PRINTF("l - Check LED");
                            put_rn();
                            PRINTF("s - CPU system info & clock");
                            put_rn();
                            PRINTF("q - Return to all mode");
                            put_rn();
                            PRINTF("? - You know this");
                            put_rn();
                            break;
                        case 'q' :        // quit
                            PRINTF("Back to all mode");
                            quitflag = 0xff;
                            break;
                        default:
                            PUTC('?');
                            put_rn();
                    }
                }
                put_rn();
                break;
                //---------------------------------------------------------------------------------
                //  check and set RTC
                //---------------------------------------------------------------------------------
            case 't' :
                put_r();
                chk_and_set_time(ptr);
                break;
                //---------------------------------------------------------------------------------
                //  help
                //---------------------------------------------------------------------------------
            case '?' :
                put_r();
                msg_hlp();
                break;
                //---------------------------------------------------------------------------------
                //  Go to special command
                //---------------------------------------------------------------------------------
            case 'x' :
                mon_hw();
                PRINTF("->Came back monitor\r\n");
                break;
                //---------------------------------------------------------------------------------
                //  Go back to main()
                //---------------------------------------------------------------------------------
            case 'q' :        // Quit
                PRINTF("\rReturn to main\r\n");
                //PRINTF("cannot control anymore from here\r\n");
                return;
                //---------------------------------------------------------------------------------
                //    no support
                //---------------------------------------------------------------------------------
            default:
                put_r();
                PUTC('?');
                put_rn();
                break;
        }
    }
}

#endif // defined(TARGET_LPC1768)
