/*
 * mbed program / cwdecoder
 *  using the Goertzel Algorithm
 *   tested on Nucleo-F411RE, F446RE, L476RG mbed board
 *
 *  Copyright (c) 2016,'17 Kenji Arai / JH1PJL
 *  http://www.page.sannet.ne.jp/kenjia/index.html
 *  http://mbed.org/users/kenjiArai/
 *      Started:  January  19th, 2017
 *      Revised:  January  27th, 2017
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
 * IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
 * DAMAGES OR OTHER  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR
 * OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR
 * THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */
///////////////////////////////////////////////////////////////////////
// CW Decoder made by Hjalmar Skovholm Hansen OZ1JHM  VER 1.01       //
// Feel free to change, copy or what ever you like but respect       //
// that license is http://www.gnu.org/copyleft/gpl.html              //
// Discuss and give great ideas on                                   //
// https://groups.yahoo.com/neo/groups/oz1jhm/conversations/messages //
///////////////////////////////////////////////////////////////////////

//  Definition -----------------------------------------------------------------
//////////// Sampling Conditions ///////////////////////////////////////////////
#define SAMPLE_RATE     8000.0f     // 8KHz
#define TARGET_FREQ     750.0f      // 750Hz
#define SAMPLE_NUM      100         // 100 samples
////////////////////////////////////////////////////////////////////////////////

//////////// Operating condition ///////////////////////////////////////////////
// Use Virtual COM line to PC
#if 1   // 1: use, 0: Not use
#define USE_COM         // use Communication with PC(UART)
#endif
// Output debug information
#if 0   // 1: use, 0: Not use
#define USE_DEBUG
#endif
////////////////////////////////////////////////////////////////////////////////

//////////// Fixed condition ///////////////////////////////////////////////////
#define HIGH            1
#define LOW             0
#define PI              3.141592653f
#define MILLIS()        t.read_ms()


#ifdef USE_COM
#define BAUD(x)         pc.baud(x)
#define GETC(x)         pc.getc(x)
#define PUTC(x)         pc.putc(x)
#define PRINTF(...)     pc.printf(__VA_ARGS__)
#define READABLE(x)     pc.readable(x)
#else
#define BAUD(x)         {;}
#define GETC(x)         {;}
#define PUTC(x)         {;}
#define PRINTF(...)     {;}
#define READABLE(x)     {;}
#endif

#ifdef USE_DEBUG
#define DEBUG(...)      pc.printf(__VA_ARGS__)
#else
#define DEBUG(...)      {;}
#endif
////////////////////////////////////////////////////////////////////////////////

//------------------------------------------------------------------------------
// Old configuration
//------------------------------------------------------------------------------
#if 0
//////////// Sampling Conditions ///////////////////////////////////////////////
#define SAMPLE_RATE     8000.0f     // 8KHz
#define TARGET_FREQ     1000.0f     // 1KHz
#define SAMPLE_NUM      100         // 100 samples
////////////////////////////////////////////////////////////////////////////////
#endif
#if 0
//////////// Sampling Conditions ///////////////////////////////////////////////
#define SAMPLE_RATE     12000.0f    // 12KHz
#define TARGET_FREQ     750.0f      // 750Hz
#define SAMPLE_NUM      50          // 50 samples
////////////////////////////////////////////////////////////////////////////////
#endif
#if 0
//////////// Sampling Conditions ///////////////////////////////////////////////
#define SAMPLE_RATE     48000.0f    // 48KHz
#define TARGET_FREQ     800.0f      // 800Hz
#define SAMPLE_NUM      100         // 100 samples
////////////////////////////////////////////////////////////////////////////////
#endif

