/*
 * Mbed Application program
 *  check program for MCP3425 16-Bit Analog-to-Digital Converter
 *      http://www.microchip.com/wwwproducts/en/MCP3425
 *      http://akizukidenshi.com/catalog/g/gK-08018/
 *
 * Copyright (c) 2018 Kenji Arai / JH1PJL
 *  http://www.page.sannet.ne.jp/kenjia/index.html
 *  http://mbed.org/users/kenjiArai/
 *      Modify:     March     17th, 2018
 *      Revised:    March     18th, 2018
 */

//  Include --------------------------------------------------------------------
#include "mbed.h"
#include "MCP3425.h"

//  Definition -----------------------------------------------------------------
//#define     EXAMPLE_0
//#define     EXAMPLE_1
#define     EXAMPLE_2
//#define     EXAMPLE_3
//#define     EXAMPLE_4
//#define     EXAMPLE_5

//  Object ---------------------------------------------------------------------
Serial      pc(USBTX, USBRX);       // Communication with Host
MCP3425     adc(I2C_SDA, I2C_SCL);    //setup max31855 interface
Timer       t;

//  RAM ------------------------------------------------------------------------

//  ROM / Constant data --------------------------------------------------------

//  Function prototypes --------------------------------------------------------

//------------------------------------------------------------------------------
//  Control Program
//------------------------------------------------------------------------------
#ifdef EXAMPLE_0
int main() {
// Default parameter setting
// Continuous Conversion + 15 SPS (16 bits) + Gain x1
    while(true){
        printf("ADC: %6.5f [V]\r\n", adc.read_voltage());
        wait(0.2f);
    }
}
#endif

#ifdef EXAMPLE_1
int main()
{
    while(true) {
        pc.printf("ADC= %d\r\n", adc.read_16bit());
    }
}
#endif

#ifdef EXAMPLE_2
int main()
{
    mcp3425_config_t my_config;
    float dt;
    uint32_t conv_time;

    my_config.pga_gain = PGA_GAIN_1;
    //my_config.pga_gain = PGA_GAIN_2;
    //my_config.pga_gain = PGA_GAIN_4;
    //my_config.pga_gain = PGA_GAIN_8;
    //my_config.sample_rate = SAMPLE_RATE_240SPS_12BIT;
    //my_config.sample_rate = SAMPLE_RATE_60SPS_14BIT;
    my_config.sample_rate = SAMPLE_RATE_15SPS_16BIT;
    my_config.conversion_mode = CONV_MODE_CONTINUOUS;
    adc.set_config(&my_config);
    adc.set_offset_volt(0.00037f);
    adc.set_vref_compensation(0.99303f);
    while(true) {
        t.reset();
        t.start();
        dt = adc.read_voltage();
        conv_time = t.read_us();
        pc.printf("ADC= %6.5f [V], Cnv.time= %d [uS]\r\n", dt, conv_time);
        wait(0.5f);
    }
}
#endif

#ifdef EXAMPLE_3
int main()
{
    adc.frequency(400000U);
    while(true) {
        pc.printf("ADC= %d\r\n", adc.read_16bit());
    }
}
#endif

#ifdef EXAMPLE_4
int main()
{
    mcp3425_config_t my_config;
    uint16_t dt;
    uint32_t conv_time;

    my_config.pga_gain = PGA_GAIN_1;
    my_config.sample_rate = SAMPLE_RATE_240SPS_12BIT;
    //my_config.sample_rate = SAMPLE_RATE_60SPS_14BIT;
    //my_config.sample_rate = SAMPLE_RATE_15SPS_16BIT;
    my_config.conversion_mode = CONV_MODE_ONE_SHOT;
    //my_config.conversion_mode = CONV_MODE_CONTINUOUS;
    adc.set_config(&my_config);
    while(true) {
        t.reset();
        t.start();
        dt = adc.read_16bit();
        conv_time = t.read_us();
        pc.printf("ADC= %6d, Conv. time= %d [uS]\r\n", dt, conv_time);
        wait(0.5f);
    }
}
#endif

#ifdef EXAMPLE_5
int main()
{
    mcp3425_config_t my_config;
    uint16_t dt;
    uint32_t conv_time;

    //my_config.pga_gain = PGA_GAIN_1;
    //my_config.pga_gain = PGA_GAIN_2;
    //my_config.pga_gain = PGA_GAIN_4;
    my_config.pga_gain = PGA_GAIN_8;
    my_config.sample_rate = SAMPLE_RATE_15SPS_16BIT;
    my_config.conversion_mode = CONV_MODE_CONTINUOUS;
    adc.set_config(&my_config);
    adc.frequency(400000U);
    while(true) {
        t.reset();
        t.start();
        dt = adc.read_16bit();
        conv_time = t.read_us();
        pc.printf("ADC= %6d, Conv. time= %d [uS]\r\n", dt, conv_time);
        wait(0.5f);
    }
}
#endif
