/*
    Modified by Kenji Arai / JH1PJL
        March 20th, 2020

    Original & Refrence
        https://os.mbed.com/users/chris/code/ChrisRGB-Ring/
        https://os.mbed.com/users/chris/code/WS2812/
        https://os.mbed.com/users/chris/code/PixelArray/

        https://os.mbed.com/users/bridadan/code/WS2812_Example/
        https://os.mbed.com/users/bridadan/code/WS2812/
        https://os.mbed.com/users/chris/code/PixelArray/

 */

#include "mbed.h"
#include "WS2812.h"
#include "PixelArray.h"

#if (MBED_MAJOR_VERSION == 5)
#define WAIT_MS(x)  ThisThread::sleep_for(x)
#else
#define WAIT_MS(x)  wait_ms(x)
#endif

// NeoPixel Board
#define WS2812_BUF  64
#define NUM_LEDS_PER_COLOR 8
// Preparation color number
#define NUM_COLORS  8
// Intensity base
#define BRIGHT      0xf     // Max = 0xf

// Only OS2 ->F334RG, L053, L073&L476(can compile on os5 but not work)
#if \
    defined(TARGET_NUCLEO_F334R8)\
 || defined(TARGET_NUCLEO_F401RE)\
 || defined(TARGET_NUCLEO_F411RE)\
 || defined(TARGET_NUCLEO_F446RE)\
 || defined(TARGET_NUCLEO_L053R8)\
 || defined(TARGET_NUCLEO_L073RZ)\
 || defined(TARGET_NUCLEO_L152RE)\
 || defined(TARGET_NUCLEO_L476RG)
WS2812 ws(D11, D12, D13, WS2812_BUF);
//WS2812 ws(D11, NC, NC, WS2812_BUF);   // STM does NOT support NC definition!
#elif \
    defined(TARGET_RZ_A1H)\
 || defined(TARGET_GR_LYCHEE)\
//WS2812 ws(D11, D12, D13, WS2812_BUF);
WS2812 ws(D11, NC, NC, WS2812_BUF);
#elif defined(TARGET_GR_MANGO)
//WS2812 ws(P8_6, P8_5, P8_7, WS2812_BUF);
WS2812 ws(P8_6, NC, NC, WS2812_BUF);
#else
#   error Not supprt the Board!
#endif
PixelArray px(WS2812_BUF);

int main()
{
    ws.set_brightness_mode(WS2812::PER_PIXEL); // use per-pixel brightness mode
    // set up the colours we want to draw with
    int colorbuf[NUM_COLORS] = {
            0x2f0000,0x2f2f00,0x002f00,0x002f2f,
            0x00002f,0x2f002f, 0x2f2f2f, 0
    };
    // for each of the colours (j) write out 10 of them
    // the pixels are written at the colour*10, plus the colour position
    // all modulus 60 so it wraps around
    for (int i = 0; i < WS2812_BUF; i++) {
        px.Set(i, colorbuf[(i / NUM_LEDS_PER_COLOR) % NUM_COLORS]);
    }
    // now all the colors are computed, add a fade effect using brightness data
    // compute and write the value for each pixel
    for (int j=0; j<WS2812_BUF; j++) {
        px.SetI(j%WS2812_BUF, 0xf+(BRIGHT*(j%NUM_LEDS_PER_COLOR)));
    }
    // Now the buffer is written, rotate it
    // by writing it out with an increasing offset
    while (true) {
        for (int z=WS2812_BUF; z >= 0 ; z--) {
            ws.write_offsets(px.getBuf(),z,z,z);
            WAIT_MS(100);
        }
        WAIT_MS(1000);
        ws.set_brightness(0x20);
        for (int i = 0; i < NUM_COLORS; i++) {
            ws.setAll(colorbuf[i]);
            WAIT_MS(1000);
        }
    }
}
