/*
 * Check Mbed revision
 *
 * Copyright (c) 2020 Kenji Arai / JH1PJL
 *  http://www7b.biglobe.ne.jp/~kenjia/
 *  https://os.mbed.com/users/kenjiArai/
 *      Revised:    Feburary 16th, 2020
 *      Revised:    March    12th, 2020
 */

#include "mbed.h"

//    RUN ONLY ON mbed-os5.15.1
//      https://github.com/ARMmbed/mbed-os/releases/tag/mbed-os-5.15.1
#if   (MBED_MAJOR_VERSION == 5) &&\
      (MBED_MINOR_VERSION == 15) &&\
      (MBED_PATCH_VERSION == 1)
//    RUN ONLY ON mbed 2.0.165
#elif (MBED_MAJOR_VERSION == 2) &&\
      (MBED_MINOR_VERSION == 0) &&\
      (MBED_PATCH_VERSION == 165)
#else
#     error "Please use Mbed-os5.15.1 or mbed 2.0.165"
#endif

void print_revision(void)
{
    printf("MBED_MAJOR_VERSION = %d, ", MBED_MAJOR_VERSION);
    printf("MINOR = %d, ", MBED_MINOR_VERSION);
    printf("PATCH = %d\r\n", MBED_PATCH_VERSION);
}
