/* Copyright (c) 2012 cstyles, MIT License
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom
 * the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS
 * IN THE SOFTWARE.
 */

/*
    Modified by Kenji Arai / JH1PJL
        March 20th, 2020

    Original & Refrence
        https://os.mbed.com/users/chris/code/ChrisRGB-Ring/
        https://os.mbed.com/users/chris/code/WS2812/
        https://os.mbed.com/users/chris/code/PixelArray/

        https://os.mbed.com/users/bridadan/code/WS2812_Example/
        https://os.mbed.com/users/bridadan/code/WS2812/
        https://os.mbed.com/users/chris/code/PixelArray/

 */

/*
    !!!!! This library does NOT follow specification value of the timing !!!!
        https://cdn-shop.adafruit.com/datasheets/WS2812B.pdf
        http://akizukidenshi.com/download/ds/adafruit/WS2812B.pdf

    WS2812 -> Interpretation of control timing (Not Grantee but works)
        Specification   
                    T0H     200 to 500ns
                    T1H     550 to 850ns
                    T0L     650 to 950ns
                    T1L     450 to 750ns
                    Reset   50us
        Interpretation
                    T0H     same as above
                    T1H     same as above
                    T0L     less than 10us
                    T1L     Less than 10us
                    Reset   over 50uS

    Please refer following web page
        https://wp.josh.com/2014/05/13/
                ws2812-neopixels-are-not-so-finicky-once-you-get-to-know-them/
 */

#ifndef WS2812_H
#define WS2812_H

#include "mbed.h"

#if \
    defined(TARGET_NUCLEO_F042K6)\
 || defined(TARGET_NUCLEO_F334R8)\
 || defined(TARGET_NUCLEO_F401RE)\
 || defined(TARGET_NUCLEO_F411RE)\
 || defined(TARGET_NUCLEO_F446RE)\
 || defined(TARGET_NUCLEO_L053R8)\
 || defined(TARGET_NUCLEO_L073RZ)\
 || defined(TARGET_NUCLEO_L152RE)\
 || defined(TARGET_NUCLEO_L476RG)
#   define WS1 0x0f
#   define WS0 0x0c
#   define SPICLK 8000000
#   define SPIBPF 4
#elif \
    defined(TARGET_RZ_A1H)\
 || defined(TARGET_GR_LYCHEE)\
 || defined(TARGET_GR_MANGO)
#   define WS1 0x0f
#   define WS0 0x0c
#   define SPICLK 5000000
#   define SPIBPF 8
#endif

//!Library for the WS2812 RGB LED with integrated controller
/*!
The WS2812 is controller that is built into a range of LEDs
*/
class WS2812
{
public:
    enum BrightnessControl {OFF, GLOBAL, PER_PIXEL};

    //!Creates an instance of the class.
    /*!
    Connect WS2812 using SPI MOSI pin(Only use) and MISO&SCLK(NC)
    */
    WS2812(PinName mosi, PinName miso, PinName sclk, int size);

    /*!
    Destroys instance.
    */
    ~WS2812();

    void write(int buf[]);
    void write_offsets(int buf[], int r_offset = 0,
                       int g_offset = 0, int b_offset = 0);
    void setAll(int color);

    void set_brightness_mode(BrightnessControl mode);
    void set_brightness(unsigned char br);

private:
    SPI __spi;

    void __write (int color);

    int __size;
    unsigned char __br;
    BrightnessControl __mode;

};

#endif