/*
    Modified by Kenji Arai / JH1PJL
        March 20th, 2020
 */

#include "WS2812.h"

WS2812::WS2812(PinName mosi, PinName miso, PinName sclk, int size)
    : __spi(mosi, miso, sclk)
{
    __size = size;
    __spi.format(SPIBPF,0);
    __spi.frequency(SPICLK);
     __mode = OFF;      // 0=off,1=use global,2=per pixel
     __br = 0xFF;       // set global Brightness to full
}

WS2812::~WS2812() {;}

void WS2812::write(int buf[])
{
    // for each of the data points in the buffer
    for (int i = 0; i < __size ; i++) {
        __write(buf[i]);
    }
}

void WS2812::write_offsets(int buf[], int r_offset, int g_offset, int b_offset)
{
    // for each of the data points in the buffer
    for (int i = 0; i < __size ; i++) {
        int color_one = 0x0;
        // index and extract color fields from IIRRGGBB buf[]
        // 0 = blue, 1 = green, 2 = red, 3 = brightness
        color_one |= (buf[(i+b_offset)%__size] & 0x000000ff);
        color_one |= (buf[(i+g_offset)%__size] & 0x0000ff00);
        color_one |= (buf[(i+r_offset)%__size] & 0x00ff0000);
        color_one |= (buf[i] & 0xff000000);
        __write(color_one);
    }
}

void WS2812::setAll(int color)
{
    int color_one = ( __br << 24) | color;
    // for each of the data points in the buffer
    for (int i = 0; i < __size ; i++) {
        __write(color_one);
    }
}

void WS2812::set_brightness_mode(BrightnessControl mode)
{
     __mode = mode;
}

void WS2812::set_brightness(unsigned char br)
{
     __br = br;
}

void WS2812::__write(int color)
{
    // Input format(color)  :   GGRRBB
    // Output format(agrb)  : IIRRGGBB
    unsigned char agrb[4];
    unsigned char sf;           // scaling factor for  II
    // extract color fields from incoming
    // 0 = blue, 1 = red, 2 = green, 3 = brightness
    agrb[0] = (unsigned char)color;
    agrb[1] = (unsigned char)((color & 0x00ff0000) >> 16);
    agrb[2] = (unsigned char)((color & 0x0000ff00) >>  8);
    agrb[3] = (unsigned char)((color & 0xff000000) >> 24);
    // set and intensity scaling factor (global, per pixel, none = Max)
    if ( __mode == GLOBAL) {
        sf =  __br;
    } else if ( __mode == PER_PIXEL) {
        sf = agrb[3];
    } else {
        sf = 0xff;
    }
    // Input format(agrb[4])  : IIRRGGBB
    // Output format(agrb[3]) : RR*II, GG*II, BB*II
    // Apply the scaling factor to each on the color components
    for (int clr = 2; clr >= 0; clr--) {
        agrb[clr] = (agrb[clr] * sf) >> 8;
    }
    // For each color component G,R,B
    // shift out the data 7..0, writing a SPI frame per bit
    // green=2,red=1,blue=0,
    char bit_ptn[8] = {1, 2, 4, 8, 16, 32, 64, 128};
    for (int32_t clr = 2; clr >= 0; clr--) {
        unsigned char dt = agrb[clr];
        for (int32_t bit = 7 ; bit >= 0 ; bit--) {
            if (dt & bit_ptn[bit]) {
                __spi.write(WS1);
            } else {
                __spi.write(WS0);
            }
            // debug purpose
            //wait_us(30);
        }
    }
}
