//
//  Text LCD Control Program
//          Kenji Arai / JH1PJL
//          March 7th,2010  Started
//          March 27th,2010  
//

#include "mbed.h"
#include "TextLCD.h"

#define LINE_40_2

#define BLINK_PERIOD 1.8        // LED on period (Initial data)
#define END_PERIOD 0.0001       // Finish period

DigitalOut myled1(LED1);        // Assign LED output port LED1 to LED4
DigitalOut myled2(LED2);
DigitalOut myled3(LED3);
DigitalOut myled4(LED4);

#ifdef LINE_40_2
TextLCD lcd(p22, p28, p27, p26, p25, p24, p23, 40, 2); // rs,rw,e,d0,d1,d2,d3,40char's x 2 lines
#else
TextLCD lcd(p22, p28, p27, p26, p25, p24, p23, 16, 2); // rs,rw,e,d0,d1,d2,d3,16char's x 2 lines
#endif

int main() {
    float tim;
    long count;
    char buf[40];

    tim = BLINK_PERIOD;
    count = 0;
    lcd.cls();
    lcd.locate(0, 0);
#ifdef LINE_40_2
    //          0         1         2         3        40
    lcd.printf("1234567890123456789012345678901234567890");
    lcd.locate(0, 1);
    lcd.printf("0987654321098765432109876543210987654321");
#else
    //          0         1     
    lcd.printf("1234567890123456");
    lcd.locate(0, 1);
    lcd.printf("6543210987654321");
#endif
    // If you have implemented the "Windows USB Serial Port Driver", you can use follows.
    // http://mbed.org/projects/handbook/wiki/WindowsSerialConfiguration
    printf("\r\n  Start LCD Test Program\r\n");
    while (1) {
        for (tim =BLINK_PERIOD; tim >=  END_PERIOD; tim /= 3) {
            myled1 = 1;
            wait(tim);
            myled1 = 0;
            myled2 = 1;
            wait(tim);
            myled2 = 0;
            myled3 = 1;
            wait(tim);
            myled3 = 0;
            myled4 = 1;
            wait(tim);
            myled4 = 0;
        }
        lcd.cls();
        lcd.locate(0, 0);   // 1st line top
#ifdef LINE_40_2
        //                   1         2         3         4
        //          1234567890123456789012345678901234567890
        lcd.printf("This is a test program for checking LCD ");
        lcd.locate(0, 1);   // 2nd line top
        sprintf(buf," Current loop count number = %d ", count);
#else
        //          1234567890123456
        lcd.printf("LCD test program");
        lcd.locate(0, 1);   // 2nd line top
        sprintf(buf,"loop # = %d", count);
#endif
        lcd.printf(buf);
        printf(" Current loop count number = %d \r\n", count);
        count++;
    }
}
