/*
 * Mbed Application program
 *  SoftSerial(also BufferedSoftSerial) function test programs
 *  UART 3 channels
 *      (1) Mbed Serial communication line as "pc"
 *      (2) CPU another UART channel as "ser"
 *      (3) Software Serial channel as "dev"
 *
 * Copyright (c) 2020 Kenji Arai / JH1PJL
 *  http://www7b.biglobe.ne.jp/~kenjia/
 *  https://os.mbed.com/users/kenjiArai/
 *      Created:    May        9th, 2020
 *      Revised:    May       10th, 2020
 */

/*
    Tested board on OS5.15.3
        Nucleo-F446RE, Nucleo-L432KC
 */

//  Pre-selection --------------------------------------------------------------
#include    "select_example.h"
//#define EXAMPLE_2
#ifdef EXAMPLE_2
#warning "Select 2"

//  Include --------------------------------------------------------------------
#include "mbed.h"
#include "BufferedSoftSerial.h"

//  Definition -----------------------------------------------------------------
#define BEFFERED    1
    
//  Constructor ----------------------------------------------------------------
#if defined(TARGET_NUCLEO_L432KC)
DigitalOut test_point(D12);
Serial ser(D5, D4, 9600);
#   if BEFFERED
    BufferedSoftSerial dev(D6,D3);
#   else
    SoftSerial dev(D6,D3);
#   endif
#elif defined(TARGET_NUCLEO_F446RE)
DigitalOut test_point(A0);
Serial ser(D8, D2, 9600);
#   if BEFFERED
    BufferedSoftSerial dev(D4,D3);
#   else
    SoftSerial dev(D4,D3);
#   endif
#endif
Serial pc(USBTX,USBRX, 9600);

//  RAM ------------------------------------------------------------------------

//  ROM / Constant data --------------------------------------------------------

//  Function prototypes --------------------------------------------------------

//------------------------------------------------------------------------------
//  Control Program
//------------------------------------------------------------------------------
/*
    UART 3 channels
        (1) Mbed Serial communication line as "pc"
        (2) CPU another UART channel as "ser"
        (3) Software Serial channel as "dev"
 */
int main()
{
    while(true) {
        char c = dev.getc();// get serial data
        dev.putc(c);        // echo back to softserial port
        ser.putc(c);        // another UART
        pc.putc(c);         // Mbed Serial
    }
}

#endif //#ifdef EXAMPLE_2