/*
 * Mbed Application program
 *  SoftSerial(also BufferedSoftSerial) function test programs
 *  UART 3 channels
 *      (1) Mbed Serial communication line as "pc"
 *      (2) CPU another UART channel as "ser"
 *      (3) Software Serial channel as "dev"
 *
 * Copyright (c) 2020 Kenji Arai / JH1PJL
 *  http://www7b.biglobe.ne.jp/~kenjia/
 *  https://os.mbed.com/users/kenjiArai/
 *      Created:    May        9th, 2020
 *      Revised:    May       10th, 2020
 */

/*
    Tested board on OS5.15.3
        Nucleo-F446RE, Nucleo-L432KC
 */

//  Pre-selection --------------------------------------------------------------
#include    "select_example.h"
//#define EXAMPLE_0
#ifdef EXAMPLE_0
#warning "Select 0"

//  Include --------------------------------------------------------------------
#include "mbed.h"
#include "BufferedSoftSerial.h"

//  Definition -----------------------------------------------------------------
#define BEFFERED    1
    
//  Constructor ----------------------------------------------------------------
#if defined(TARGET_NUCLEO_L432KC)
DigitalOut test_point(D12);
Serial ser(D5, D4, 9600);
#   if BEFFERED
    BufferedSoftSerial dev(D6,D3);
#   else
    SoftSerial dev(D6,D3);
#   endif
#elif defined(TARGET_NUCLEO_F446RE)
DigitalOut test_point(A0);
Serial ser(D8, D2, 9600);
#   if BEFFERED
    BufferedSoftSerial dev(D4,D3);
#   else
    SoftSerial dev(D4,D3);
#   endif
#endif
Serial pc(USBTX,USBRX, 9600);

//  RAM ------------------------------------------------------------------------

//  ROM / Constant data --------------------------------------------------------

//  Function prototypes --------------------------------------------------------

//------------------------------------------------------------------------------
//  Control Program
//------------------------------------------------------------------------------
/*
    UART 3 channels
        (1) Mbed Serial communication line as "pc"
        (2) CPU another UART channel as "ser"
        (3) Software Serial channel as "dev"
 */
int main()
{
    int count = 0;
    while(true) {
        for (uint32_t i = '!'; i < '~'; i++) {
            dev.putc(i);        // output to softserial
            ser.putc(i);        // output to another UART
            pc.putc(i);         // output to PC
        }
        dev.puts("----> ABCDEFGHIJKLMOPQRSTUVWXYZ0123456789");
        ser.puts("----> ABCDEFGHIJKLMOPQRSTUVWXYZ0123456789");
        pc.puts( "----> ABCDEFGHIJKLMOPQRSTUVWXYZ0123456789");
        dev.printf("--------->%4d\r\n", count);
        ser.printf("--------->%4d\r\n", count);
        pc.printf( "--------->%4d\r\n", count++);
    }
}

#endif //#ifdef EXAMPLE_0
