/*
 * Mbed Application program
 *  SoftSerial(also BufferedSoftSerial) function test programs
 *  UART 3 channels
 *      (1) Mbed Serial communication line as "pc"
 *      (2) CPU another UART channel as "ser"
 *      (3) Software Serial channel as "dev"
 *
 * Copyright (c) 2020 Kenji Arai / JH1PJL
 *  http://www7b.biglobe.ne.jp/~kenjia/
 *  https://os.mbed.com/users/kenjiArai/
 *      Created:    May        9th, 2020
 *      Revised:    May       11th, 2020
 */

/*
    Tested board on OS5.15.3
        Nucleo-F446RE, Nucleo-L432KC
 */

//  Pre-selection --------------------------------------------------------------
#include    "select_example.h"
//#define EXAMPLE_3
#ifdef EXAMPLE_3
#warning "Select 3"

//  Include --------------------------------------------------------------------
#include "mbed.h"
#include "BufferedSoftSerial.h"

//  Definition -----------------------------------------------------------------
#if (MBED_MAJOR_VERSION == 2)
#error "Cannot run on OS2"
#endif

#define BAUD    9600
//#define BAUD    14400
//#define BAUD    19200  // No continuous transmission           
//#define BAUD    38400  // NOT SUCCESS!!

//  Constructor ----------------------------------------------------------------
#if defined(TARGET_NUCLEO_L432KC)
DigitalOut test_point(D12);
Serial ser(D5, D4, BAUD);
BufferedSoftSerial dev(D6,D3);
#elif defined(TARGET_NUCLEO_F446RE)
DigitalOut test_point(A0);
Serial ser(D8, D2, BAUD);
BufferedSoftSerial dev(D4,D3);
#endif
Serial pc(USBTX,USBRX, BAUD);

//  RAM ------------------------------------------------------------------------

//  ROM / Constant data --------------------------------------------------------

//  Function prototypes --------------------------------------------------------
void pc2dev(void const *args);
void dev2pc(void const *args);

//------------------------------------------------------------------------------
//  Control Program
//------------------------------------------------------------------------------
osThreadDef(pc2dev, osPriorityNormal,1024);
osThreadDef(dev2pc, osPriorityNormal,1024);

int main()
{
    dev.baud(BAUD);
    // Start tasks
    osThreadCreate(osThread(pc2dev), NULL);
    osThreadCreate(osThread(dev2pc), NULL);
    // main routine
    int count = 0;
    while(true) {
        ser.printf( "Time passed %4d [sec]\r\n", count++);
        ThisThread::sleep_for(1000);
    }
}

void pc2dev(void const *args)
{
    while(true) {
        if (pc.readable()) {
            dev.putc(pc.getc());
        } else {
            ThisThread::yield();
        }
    }
}

void dev2pc(void const *args)
{
    while(true) {
        if (dev.readable()) {
            pc.putc(dev.getc());
        } else {
            ThisThread::yield();
        }
    }
}

#endif //#ifdef EXAMPLE_3