/*
 * Mbed Application program
 *  IR TX & RX test program
 *
 * Copyright (c) 2020 Kenji Arai / JH1PJL
 *  http://www7b.biglobe.ne.jp/~kenjia/
 *  https://os.mbed.com/users/kenjiArai/
 *      Created:    May       15th, 2020
 *      Revised:    May       15th, 2020
 */

//  Include --------------------------------------------------------------------
#include "mbed.h"
#include "Bf_SoftSerial_IR.h"

//  Object ---------------------------------------------------------------------
DigitalOut  myled(LED1);
DigitalOut  test_point(A5);
RawSerial   pc(USBTX, USBRX);
Bf_SoftSerial_IR  ir_trx(PB_2, PA_14);

//  RAM ------------------------------------------------------------------------
CircularBuffer<char, 1024> pc_rxbuf;    // PC receiving Buffer

//  ROM / Constant data --------------------------------------------------------

//  Function prototypes --------------------------------------------------------
static void pc_rx_handler(void);

//------------------------------------------------------------------------------
//  Control Program
//------------------------------------------------------------------------------
int main()
{
    char c;

    pc.attach(&pc_rx_handler, Serial::RxIrq);
    pc.printf("\r\nStart UART test program\r\n");
    while(true){
        //pc.printf("line:%d\r\n", __LINE__);
        if (!pc_rxbuf.empty()){
            pc_rxbuf.pop(c);
            ir_trx.putc(c);
        }
        if (ir_trx.readable()){
            c = ir_trx.getc();
            if ((c == '\r') || (c == '\n')){
                pc.putc('\r');
                pc.putc('\n');
            } else if (c == 0xff){
                ;   // no action -> Noise!!
            } else {
                pc.putc(c);
            }
        }
    }
}

static void pc_rx_handler(void)
{
    while(pc.readable()) {
        pc_rxbuf.push(pc.getc());
    }
}
