/*
 * Check Mbed revision
 *
 * Copyright (c) 2019,'20 Kenji Arai / JH1PJL
 *  http://www7b.biglobe.ne.jp/~kenjia/
 *  https://os.mbed.com/users/kenjiArai/
 *      Created:    July      17th, 2019
 *      Revised:    May        2nd, 2020
 */

#include "mbed.h"
 
//    RUN ONLY ON mbed-os-5.15.3
//      https://github.com/ARMmbed/mbed-os/releases/tag/mbed-os-5.15.3
#if (MBED_MAJOR_VERSION == 5) &&\
    (MBED_MINOR_VERSION == 15) &&\
    (MBED_PATCH_VERSION == 3)
#elif (MBED_MAJOR_VERSION == 2) &&\
    (MBED_MINOR_VERSION == 0) &&\
    (MBED_PATCH_VERSION == 165)
#else
    //#warning "Please use mbed-os-5.15.3"
    #error "Please use mbed-os-5.15.3"
#endif

void print_revision(void)
{
    printf("MBED_MAJOR_VERSION = %d, ", MBED_MAJOR_VERSION);
    printf("MINOR = %d, ", MBED_MINOR_VERSION);
    printf("PATCH = %d\r\n", MBED_PATCH_VERSION);
}
