/*
 * Mbed Application program
 *  SoftSerial(also BufferedSoftSerial) function test programs
 *  UART 2 channels
 *      (1) Mbed Serial communication line as "pc"
 *      (2) Software Serial channel as "dev"
 *
 * Copyright (c) 2020 Kenji Arai / JH1PJL
 *  http://www7b.biglobe.ne.jp/~kenjia/
 *  https://os.mbed.com/users/kenjiArai/
 *      Created:    May        9th, 2020
 *      Revised:    May       12th, 2020
 */

/*
    Tested board on OS5.15.3
        Nucleo-L152RE,
        Nucleo-F401RE, -F411RE, -F446RE,
        Nucleo-L432KC, -L476RG
        FRDM-K64F
        
    CAUTION!!
        Due to bug inside TimerEvent, not stable on STM32 series Mbed
        at this moment.
        FRDM-K40 works fine(no trouble TimerEvent function).
 */

//  Include --------------------------------------------------------------------
#include "mbed.h"
#include "BufferedSoftSerial.h"

//  Definition -----------------------------------------------------------------
#define BAUD    9600
//#define BAUD    14400
//#define BAUD    19200  // No continuous transmission           
//#define BAUD    38400  // NOT SUCCESS!!

//  Constructor ----------------------------------------------------------------
#if defined(TARGET_NUCLEO_L432KC)
DigitalOut test_point(D12);
Serial ser(D5, D4, BAUD);
BufferedSoftSerial dev(D6,D3);
#else
DigitalOut test_point(A0);
BufferedSoftSerial dev(D4,D3);
#endif
Serial pc(USBTX,USBRX, BAUD);

//  RAM ------------------------------------------------------------------------

//  ROM / Constant data --------------------------------------------------------

//  Function prototypes --------------------------------------------------------
void pc2dev(void const *args);
void dev2pc(void const *args);

//------------------------------------------------------------------------------
//  Control Program
//------------------------------------------------------------------------------
osThreadDef(pc2dev, osPriorityNormal,1024);
osThreadDef(dev2pc, osPriorityNormal,1024);

int main()
{
    dev.baud(BAUD);
    // Start tasks
    osThreadCreate(osThread(pc2dev), NULL);
    osThreadCreate(osThread(dev2pc), NULL);
    while(true) {
        ThisThread::sleep_for(1000000);
    }
}

void pc2dev(void const *args)
{
    pc.printf("\r\nStart program\r\n");
    while(true) {
        if (pc.readable()) {
            dev.putc(pc.getc());
        } else {
            ThisThread::yield();
        }
    }
}

void dev2pc(void const *args)
{
    dev.printf("\r\nStart program\r\n");
    while(true) {
        if (dev.readable()) {
            pc.putc(dev.getc());
        } else {
            ThisThread::yield();
        }
    }
}
