/*
 * Mbed Application program / TYBLE-16 Data logger
 *
 * Copyright (c) 2019 Kenji Arai / JH1PJL
 *  http://www.page.sannet.ne.jp/kenjia/index.html
 *  https://os.mbed.com/users/kenjiArai/
 *      Created:    December  14th, 2019
 *      Revised:    December  19th, 2019
 */

#ifndef DATA_LOGGER_H
#define DATA_LOGGER_H

//  Include --------------------------------------------------------------------
#include "RX8025NB.h"
#include "MB85RSxx_SPI.h"

//  Definition  ----------------------------------------------------------------
#define DATE_COUNT_START (1575158400)   // 2019/12/1 0:0:0
// Buffer size
#define FRAM_SIZE   256 * 2048          // 2Mbits = 256 KBytes
#define PKT_SIZE    16                  // Packet size
#define BLK_NO      16384               // 256KB/16 = 16384
#define ALL_SIZE    (PKT_SIZE) * (BLK_NO)
#if ALL_SIZ > FRAM_SIZE
    #error "Data size in FRAM is too big!"
#endif
#define PTR_SIZE    16

// Buffer control
#define RING_TOP    1
#define RING_TAIL   (BLK_NO - RING_TOP -1)
#define BLK_SIZE    16

//  Function prototypes --------------------------------------------------------
void mon(RX8025 &ex_rtc, MB85RSxx_SPI &fram);
void dtlog_data_pack(void);
void dtlog_one_write(MB85RSxx_SPI &fram);

#endif  // DATA_LOGGER_H