/*
 * AE-TYBLE16 Module example programs
 *
 * Copyright (c) 2018 Kenji Arai / JH1PJL
 *  http://www.page.sannet.ne.jp/kenjia/index.html
 *  https://os.mbed.com/users/kenjiArai/
 *      Created:    April      7th, 2018
 *      Revised:    April     15th, 2018
 *      Revised:    November  25th, 2018   Change os2 to os5
 */

/*
    SEPARATED THE PROGRAM DUE TO MEMORY SPACE IS OVERFLOW
    You can select several examples as followings.
    7 & 8.  7_Uart_Client & 8_Uart_Server
        Uart Client(Central) and Server(Peripheral)
        -> PLEASE SET VCOM BAUDRATE IS 115200
    9.  9_Monitor
        Check nRF51 CPU functions
 */
#define EXAMPLE_NUMBER      8   // select 7 or 8

//----------------- You don't need any modification ----------------------------
#if EXAMPLE_NUMBER == 7
    #define EXAMPLE_7_UART_CLIENT
    #ifdef EXAMPLE_7_UART_CLIENT
        #include "7_Uart_Client/main.cpp"
        #warning "Please set VCOM baudrate -> 115200 ""
    #endif
#elif EXAMPLE_NUMBER == 8
    #define EXAMPLE_8_UART_SERVER
    #ifdef EXAMPLE_8_UART_SERVER
        #include "8_Uart_Server/main.cpp"
        #warning "Please set VCOM baudrate -> 115200 ""
    #endif
#else
        #error " Please set 0 to 9 number for EXAMPLE_NUMBER!!"
#endif
