/*
 * AE-TYBLE16 Module example programs
 *
 * Copyright (c) 2018,'19 Kenji Arai / JH1PJL
 *  http://www.page.sannet.ne.jp/kenjia/index.html
 *  https://os.mbed.com/users/kenjiArai/
 *      Created:    April      7th, 2018
 *      Revised:    April     15th, 2018
 *      Revised:    December  19th, 2019
 */


/*
    You can select several examples as followings.
    0.  0_Blinky_LED
        LED Blinky
    1.  1_Check_RTC
        Check RTC function
        -> Time is not so accurate because 32.768KHz is made by Internal RC osc.
    2.  2_EddyStoneBeacon
        Demonstration sample program EddyStone Beacon
    3.  3_Heart_Rate
        Demonstration sample program Heart Rate
    4.  4_RCBController
        Potential usage for Radio Controller (RCB Controller)
    5.  5_SDCard
        Demonstration sample program SD Card
    6.  6_Thermo
        Demonstration sample program Thermometer
        -> If you have I2C temperature sensor, you can connect it.
        -> LCD can display the data.
    7 & 8.  7_Uart_Client & 8_Uart_Server
        Uart Client(Central) and Server(Peripheral)
        -> PLEASE SET VCOM BAUDRATE IS 115200
        https://os.mbed.com/users/kenjiArai/
                        code/TYBLE16_mbedlized_os5_several_examples_2/
    9.  9_Monitor
        Check TYBLE16/nRF51 CPU functions
 */
#define EXAMPLE_NUMBER      9   // select 0 to 6 & 9

//----------------- You don't need any modification ----------------------------
#if EXAMPLE_NUMBER == 0
    #define EXAMPLE_0_BLINKY_LED
    #ifdef EXAMPLE_0_BLINKY_LED
        #include "0_Blinky_LED/main.cpp"
        #warning "Select 0_Blinky_LED"
    #endif
#elif EXAMPLE_NUMBER == 1
    #define EXAMPLE_1_CHECK_RTC
    #ifdef EXAMPLE_1_CHECK_RTC
        #include "1_Check_RTC/main.cpp"
        #warning "Select 1_Check_RTC"
    #endif
#elif EXAMPLE_NUMBER == 2
    #define EXAMPLE_2_EDDYSTONE_BEACON
    #ifdef EXAMPLE_2_EDDYSTONE_BEACON
        #include "2_EddyStoneBeacon/main.cpp"
        #warning "Select 2_EddyStoneBeacon"
    #endif
#elif EXAMPLE_NUMBER == 3
    #define EXAMPLE_3_HEART_RATE
    #ifdef EXAMPLE_3_HEART_RATE
        #include "3_Heart_Rate/main.cpp"
        #warning "Select 3_Heart_Rate"
    #endif
#elif EXAMPLE_NUMBER == 4
    #define EXAMPLE_4_RCB_CONTROLLER
    #ifdef EXAMPLE_4_RCB_CONTROLLER
        #include "4_RCBController/main.cpp"
        #warning "Select 4_RCBController"
    #endif
#elif EXAMPLE_NUMBER == 5
    #define EXAMPLE_5_SDCARD
    #ifdef EXAMPLE_5_SDCARD
        #include "5_SDCard/main.cpp"
        #warning "Select 5_SDCard"
    #endif
#elif EXAMPLE_NUMBER == 6
    #define EXAMPLE_6_THERMO
    #ifdef EXAMPLE_6_THERMO
        #include "6_Thermo/main.cpp"
        #warning "Select 6_Thermo"
    #endif
#elif EXAMPLE_NUMBER == 7
    #error "Please use TYBLE16_mbedlized_os5_several_examples_2nd"
#elif EXAMPLE_NUMBER == 8
    #error "Please use TYBLE16_mbedlized_os5_several_examples_2nd"
#elif EXAMPLE_NUMBER == 9
    #define EXAMPLE_9_MONITOR
    #ifdef EXAMPLE_9_MONITOR
        #include "9_Monitor/main.cpp"
        #warning "Select 9_Monitor"
    #endif
#else
    #error " Please set 0 to 9 number for EXAMPLE_NUMBER!!"
#endif
