/*
 *      December 31st, 2015     Modified by Kenji Arai
 *		January  19th, 2016
 *		October  12th, 2017		!! Run on Mbed-os5
 *                              http://www.page.sannet.ne.jp/kenjia/index.html
 *                              https://os.mbed.com/users/kenjiArai/
 *		April    14th, 2018		run on TYBLE16
 *      December 19th, 2019
 *
 *  Original:
 *   BLE_RCBController2_Motor
 *   https://developer.mbed.org/users/robo8080/code/BLE_RCBController2_Motor/
 *  Tested Controller Device:
 *   iPhone6 RCBController (Ver1.4.0)
 *   https://itunes.apple.com/jp/app/rcbcontroller/id689724127?mt=8
 */

//#define EXAMPLE_4_RCB_CONTROLLER
#ifdef EXAMPLE_4_RCB_CONTROLLER

#include "mbed.h"
#include "BLE.h"
#include "RCBController.h"
#include "TYBLE16_BASE.h"

#define NEED_CONSOLE_OUTPUT	 1 // Keep 1

#if NEED_CONSOLE_OUTPUT
#define DEBUG(...) { pc.printf(__VA_ARGS__); }
#else
#define DEBUG(...)
#endif

BLE  		ble_rcb;
Serial      pc(USBTX, USBRX);

uint8_t RCBControllerPayload[10] = {0,};
RCBController 		controller;

// RCBController Service
static const uint16_t RCBController_service_uuid = 0xFFF0;
static const uint16_t RCBController_Characteristic_uuid = 0xFFF1;
const char *deviceName = "Mbed-BLE";
const char *const opngmsg =
    "\x1b[2J\x1b[H" __FILE__ "\r\n" __DATE__ " " __TIME__ " (UTC)\r\n""\r\n";

GattCharacteristic  ControllerChar (
    RCBController_Characteristic_uuid,RCBControllerPayload,10, 10,
    GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_WRITE |
    GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_WRITE_WITHOUT_RESPONSE
);
GattCharacteristic *ControllerChars[] = {&ControllerChar};
GattService         RCBControllerService(
    RCBController_service_uuid,
    ControllerChars,
    sizeof(ControllerChars) / sizeof(GattCharacteristic *)
);

//------------------------------------------------------------------------------
//  Control Program
//------------------------------------------------------------------------------
void data_analysis(void)
{
    static uint8_t cont_flg_A = 0;
    static uint8_t cont_flg_B = 0;
    static uint8_t cont_flg_X = 0;
    static uint8_t cont_flg_Y = 0;

    if (controller.status.A == 1) {
        if (cont_flg_A == 0) {
            cont_flg_A = 1;
        }
    } else {
        cont_flg_A = 0;
    }
    if (controller.status.B == 1) {
        if (cont_flg_B == 0) {
            cont_flg_B = 1;
        }
    } else {
        cont_flg_B = 0;
    }
    if (controller.status.X == 1) {
        if (cont_flg_X == 0) {
            cont_flg_X = 1;
        }
    } else {
        cont_flg_X = 0;
    }
    if (controller.status.Y == 1) {
        if (cont_flg_Y == 0) {
            cont_flg_Y = 1;
        }
    } else {
        cont_flg_Y = 0;
    }
}

void disconnectionCallback(const Gap::DisconnectionCallbackParams_t *params)
{
    DEBUG("Disconnected!\r\n");
    DEBUG("Restarting the advertising process\r\n");
    ble_rcb.startAdvertising();
}

void onDataWritten(const GattWriteCallbackParams *params)
{
    if (params->handle == ControllerChar.getValueAttribute().getHandle()) {
        uint16_t bytesRead;
        ble_rcb.readCharacteristicValue(
            ControllerChar.getValueAttribute().getHandle(),
            RCBControllerPayload, &bytesRead
        );
        memcpy( &controller.data[0], RCBControllerPayload, sizeof(controller));
        DEBUG("DATA:0x%02x 0x%02x %d %d %d %d %d %d %d 0x%02x\r\n",
              controller.data[0],controller.data[1],
              controller.data[2],controller.data[3],
              controller.data[4],controller.data[5],
              controller.data[6],controller.data[7],
              controller.data[8],controller.data[9]
             );
        data_analysis();
    }
}

int main(void)
{
    DEBUG("%s", opngmsg);
    DEBUG("\r\nInitialising the nRF51822\r\n");
    // Check TYBLE-16 configuration
    cpu_sys();
    compile_condition();

    ble_rcb.init();
    ble_rcb.setDeviceName((const uint8_t *)deviceName);
    ble_rcb.onDisconnection(disconnectionCallback);
    ble_rcb.onDataWritten(onDataWritten);
    DEBUG("Start RCB Controller\r\n");
    /* setup advertising */
    ble_rcb.accumulateAdvertisingPayload(
        GapAdvertisingData::BREDR_NOT_SUPPORTED
    );
    ble_rcb.setAdvertisingType(
        GapAdvertisingParams::ADV_CONNECTABLE_UNDIRECTED
    );
    ble_rcb.accumulateAdvertisingPayload(
        GapAdvertisingData::SHORTENED_LOCAL_NAME,
        (const uint8_t *)deviceName, strlen(deviceName)
    );
    ble_rcb.accumulateAdvertisingPayload(
        GapAdvertisingData::COMPLETE_LIST_16BIT_SERVICE_IDS,
        (const uint8_t *)RCBController_service_uuid,
        sizeof(RCBController_service_uuid)
    );
    ble_rcb.setAdvertisingInterval(160); /* 100ms; in multiples of 0.625ms. */
    ble_rcb.startAdvertising();
    ble_rcb.addService(RCBControllerService);
    while (true) {
        ble_rcb.waitForEvent();
    }
}

#endif
