/*
 * Monitor program / Memory control part
 *
 *	Copyright (c) 2010-2014,'16,'18 Kenji Arai / JH1PJL
 *	http://www.page.sannet.ne.jp/kenjia/index.html
 *  https://os.mbed.com/users/kenjiArai/
 *      Separated:	October   13th, 2014	from mon_hw.cpp
 *      Revised:	Feburary   4th, 2016
 *      Revised:    April     14th, 2018
 *
 */

//------------------------------------------------------------------------------
//  Control Program
//------------------------------------------------------------------------------
static void mem_cnfg_init( uint8_t print )
{
    uint32_t a, b, c;

    a = NRF_FICR->CODEPAGESIZE;
    b = NRF_FICR->CODESIZE;
    c = a * b;
    mem_range[0][1] = mem_range[0][0] + c -1;
    if (print) {
        PRINTF("CODEPAGESIZE:%d, CODESIZE:%d\r\nFLASH:0x%08x-0x%08x\r\n",
               a, b, mem_range[0][0], mem_range[0][1]);
    }
    a = NRF_FICR->NUMRAMBLOCK;
    b = NRF_FICR->SIZERAMBLOCKS;
    c = a * b;
    mem_range[1][1] = mem_range[1][0] + c -1;
    if (print) {
        PRINTF("NUMRAMBLOCK:%d, SIZERAMBLOCKS:%d\r\nRAM:  0x%08x-0x%08x\r\n",
               a, b, mem_range[1][0], mem_range[1][1]);
    }
}

//  Range check for Memory dump
static void check_range( MEMO * mem )
{
    uint8_t  i;
    uint32_t m;

    mem->mflg = ERR_NOTHING;
    for ( i = 0 ; i < 6 ; i++ ) {
        if ( mem->mstr >= mem_range[i][0]) {
            if ( mem->mstr < mem_range[i][1] ) {
                m = mem->mstr + mem->msiz;
                if ( m < mem_range[i][1]) {
                    return;            // no modification
                } else {
                    m = mem_range[i][1];
                    mem->msiz = m - mem->mstr + 1;
                    mem->mflg = ERR_MODIFY_SIZ;
                    return;            // modified size
                }
            }
        }
    }
    mem->mflg = ERR_OUT_OF_RANGE;
    mem->mstr = 0;
    mem->msiz = 0;
    return ;
}

//  Memory dump error massage
void error_print ( unsigned char flg )
{
    switch (flg) {
        case ERR_MODIFY_SIZ :
            put_r();
            PRINTF("Reach to out of range");
            put_rn();
            break;
        case ERR_OUT_OF_RANGE :
            put_r();
            PRINTF("Not in a memory area");
            put_rn();
            break;
        case ERR_NOTHING :
        default :
            ;
    }
}

//  Print memory contents
void put_dump (const unsigned char *buff, unsigned long ofs, int cnt)
{
    int n;

    PRINTF("%08lX ", ofs);
    for(n = 0; n < cnt; n++) {		// show hex
        PRINTF(" %02X", buff[n]);
    }
    for(; n < 16; n++) {			// fullfil remained space
        PRINTF("   ");
    }
    PUTC(' ');
    for(n = 0; n < cnt; n++) {		// show char
        if ((buff[n] < 0x20)||(buff[n] >= 0x7F)) {
            PUTC('.');
        } else {
            PUTC(buff[n]);
        }
    }
    put_rn();
}

// dump memory with error check
void dump_w_err_ckeck ( char **ptr, MEMO * mem )
{
    check_range (mem);
    for (*ptr=(char*)mem->mstr; mem->msiz >= 16; *ptr += 16, mem->msiz -= 16) {
        put_r();
        put_dump((unsigned char*)*ptr, (unsigned int)*ptr, 16);
    }
    if (mem->msiz) {
        put_dump((unsigned char*)*ptr, (unsigned int)*ptr, mem->msiz);
    }
    error_print(mem->mflg);
}

static void mem_inf (char *ptr)
{
    put_r();
    PRINTF("Mem. Mode d <address> [<count>], s, <ret> or f, q, ?");
    put_rn();
    mem_cnfg_init(0);
    mem.mstr = mem_range[0][0];     // default start address = Flash
    mem.msiz =256;
    mem.mold = 0;
    mem.mtmp = 0;
    mem.mflg = 0;
    for (; mem.mflg != 0xff;) {
        PRINTF("m>");
        ptr = linebuf;
        get_line(ptr, buf_size);
        put_r();
        switch(*ptr++) {
            case 'd' :    // d <address> [<count>] - Dump memory
                mem.mtmp = mem.mstr;
                if (!xatoi(&ptr, &mem.mstr)) {
                    mem.mstr = mem.mtmp;
                }
                if (!xatoi(&ptr, &mem.msiz)) {
                    mem.msiz = 256;
                }
                mem.mtmp = mem.msiz;
                dump_w_err_ckeck(&ptr, &mem);
                mem.mold = mem.mstr;
                mem.mstr += mem.mtmp;
                break;
            case 'f' :        // next
            case 'n' :
            case 0x0d :
                mem.msiz = 256;
                mem.mtmp = mem.msiz;
                dump_w_err_ckeck(&ptr, &mem);
                mem.mold = mem.mstr;
                mem.mstr += 256;
                break;
            case 'q' :        // quit
                mem.mflg = 0xff;
                break;
            case 'b' :        // Back to more
                if (mem.mold == 0) {
                    ;
                } else {
                    mem.mold -= 256;
                }
            case 'k' :        // keep previous address
                mem.mstr = mem.mold;
                mem.msiz = 256;
                mem.mtmp = mem.msiz;
                dump_w_err_ckeck(&ptr, &mem);
                mem.mstr += 256;
                break;
            case 'a' :        // start RAM top
                mem.mstr = mem_range[1][0];
                mem.msiz =256;
                mem.mold = 0;
                mem.mtmp = 0;
                mem.mflg = 0;
                dump_w_err_ckeck(&ptr, &mem);
                mem.mstr += 256;
                break;
            case 'o' :        // start ROM top
                mem.mstr = mem_range[0][0];
                mem.msiz =256;
                mem.mold = 0;
                mem.mtmp = 0;
                mem.mflg = 0;
                dump_w_err_ckeck(&ptr, &mem);
                mem.mstr += 256;
                break;
            case 's' :
                PRINTF("Memory Configuration");
                put_rn();
                PRINTF("%s0x%08lx to 0x%08lx ",
                       rmsg0, mem_range[0][0], mem_range[0][1]);
                put_rn();
                PRINTF("%s0x%08lx to 0x%08lx ",
                       rmsg1, mem_range[1][0], mem_range[1][1]);
                put_rn();
                PRINTF("%s0x%08lx to 0x%08lx ",
                       rmsg2, mem_range[2][0], mem_range[2][1]);
                put_rn();
                PRINTF("%s0x%08lx to 0x%08lx ",
                       rmsg3, mem_range[3][0], mem_range[3][1]);
                put_rn();
                PRINTF("%s0x%08lx to 0x%08lx ",
                       rmsg4, mem_range[4][0], mem_range[4][1]);
                put_rn();
                PRINTF("%s0x%08lx to 0x%08lx ",
                       rmsg5, mem_range[5][0], mem_range[5][1]);
                put_rn();
                break;
            case '?' :
                PRINTF("d <address> [<count>] - Dump memory");
                put_rn();
                PRINTF("s  - Show memory structure ");
                put_rn();
                PRINTF("o  - Dump memory / start from ROM top");
                put_rn();
                PRINTF("a  - Dump memory / start from RAM top");
                put_rn();
                PRINTF("k  - Dump memory / keep same 256bytes");
                put_rn();
                PRINTF("b  - Dump memory / before 256bytes");
                put_rn();
                PRINTF("<RET> or f, n - Dump memory / next 256bytes");
                put_rn();
                PRINTF("q  - Exit memory mode");
                put_rn();
                break;
            default:
                PUTC('?');
                put_rn();
        }
    }
    PRINTF("Return to All Mode");
}
