/*
 * mbed Headder file for Hardware Monitor
 *
 *  Copyright (c) 2014,'18 Kenji Arai / JH1PJL
 *  http://www.page.sannet.ne.jp/kenjia/index.html
 *  https://os.mbed.com/users/kenjiArai/
 *      Created:    June       1st, 2014
 *      Revised:    Nobember   2nd, 2014
 *      Revised:    April     14th, 2018
 *
 */

//  Object --------------------------------------------------------------------
extern Serial pc;

//  Definition -----------------------------------------------------------------
#define BAUD_RATE 9600

#define BAUD(x)             pc.baud(x)
#define GETC(x)             pc.getc(x)
#define PUTC(x)             pc.putc(x)
#define PRINTF(...)         pc.printf(__VA_ARGS__)
#define READABLE(x)         pc.readable(x)

// Range check status
#define ERR_NOTHING         0
#define ERR_MODIFY_SIZ      1
#define ERR_OUT_OF_RANGE    2

// Reg. Size
#define SIZE8               8
#define SIZE16              16
#define SIZE32              32
#define SIZE_FULL           32
#define SIZE_X              32

//  RAM ------------------------------------------------------------------------
extern char linebuf[];
extern int buf_size;

#if USE_MEM
typedef struct {
    int32_t mstr;
    int32_t msiz;
    int32_t mtmp;
    int32_t mold;
    uint8_t  mflg;
    uint8_t  mbhw;
} MEMO;
static MEMO mem;
#endif

//  Function prototypes --------------------------------------------------------
extern void put_rn ( void );
extern void put_r ( void );
extern void put_lin ( void );
extern void put_spc( uint8_t n);
extern void get_line (char *buff, int len);
extern int xatoi (char **str, int32_t *res);
