/*
 * mbed Application program
 *
 *  Copyright (c) 2016,'18Kenji Arai / JH1PJL
 *  http://www.page.sannet.ne.jp/kenjia/index.html
 *  https://os.mbed.com/users/kenjiArai/
 *      Created:    Feburary   1st, 2016
 *      Revised:    Feburary  18th, 2016
 *      Revised:    April     14th, 2018
 *
 */

//------------------------------------------------------------------------------
//  Something new and try new functions
//------------------------------------------------------------------------------
#define NRF_RTC2_BASE       0x40024000UL
#define NRF_RTC2            ((NRF_RTC_Type *) NRF_RTC2_BASE)
#define MAX_RTC_TASKS_DELAY 47  //Maximum delay until an RTC task is executed

// You do NOT need switch() sentence!!

case '1' :
step_by_step('1');
sd_power_system_off();
step_by_step('2');
NRF_RTC2->PRESCALER = 0; /* for no pre-scaling. */
NRF_RTC2->TASKS_START = 1;
n = NRF_RTC2->COUNTER;
wait(0.1);
if ( n == NRF_RTC2->COUNTER)
{
    PRINTF("RTC2 is not running\r\n");
} else
{
    PRINTF("RTC2 is running & counter = %d\r\n", n);
}
step_by_step('3');
n = NRF_RTC2->COUNTER;
wait(0.1);
if ( n == NRF_RTC2->COUNTER)
{
    PRINTF("RTC2 is not running\r\n");
} else
{
    PRINTF("RTC2 is running & counter = %d\r\n", n);
}
step_by_step('4');
n = NRF_RTC0->COUNTER;
wait(0.1);
if ( n == NRF_RTC0->COUNTER)
{
    PRINTF("RTC0 is not running\r\n");
} else
{
    PRINTF("RTC0 is running & counter = %d\r\n", n);
}
n = NRF_RTC1->COUNTER;
wait(0.1);
if ( n == NRF_RTC1->COUNTER)
{
    PRINTF("RTC1 is not running\r\n");
    NRF_RTC1->PRESCALER = 0; /* for no pre-scaling. */
    NRF_RTC1->TASKS_START = 1;
    wait(0.5);
    n = NRF_RTC1->COUNTER;
    wait(0.1);
    if ( n == NRF_RTC1->COUNTER) {
        PRINTF("RTC1 is not running\r\n");
    } else {
        PRINTF("RTC1 is running & counter = %d\r\n", n);
    }
} else
{
    PRINTF("RTC1 is running & counter = %d\r\n", n);
}
break;
case '2' :
step_by_step('1');
// Stop Radio
NRF_RADIO->SHORTS          = 0;
NRF_RADIO->EVENTS_DISABLED = 0;
NRF_RADIO->TEST            = 0;
NRF_RADIO->TASKS_DISABLE   = 1;
while (NRF_RADIO->EVENTS_DISABLED == 0)
{
    ;// Do nothing.
}
NRF_RADIO->EVENTS_DISABLED = 0;
// Set RTC1 for wake-up
NVIC_ClearPendingIRQ(RTC1_IRQn);
NVIC_DisableIRQ(RTC1_IRQn);
NRF_RTC1->TASKS_STOP = 1;
nrf_delay_us(MAX_RTC_TASKS_DELAY);
NRF_RTC1->TASKS_CLEAR = 1;
nrf_delay_us(MAX_RTC_TASKS_DELAY);
NRF_RTC1->INTENCLR = RTC_INTENSET_COMPARE0_Msk;
NRF_RTC1->EVTENCLR = RTC_EVTEN_COMPARE0_Msk;
NRF_RTC1->INTENCLR = RTC_INTENSET_OVRFLW_Msk;
NRF_RTC1->EVTENCLR = RTC_EVTEN_OVRFLW_Msk;
NRF_RTC1->EVENTS_COMPARE[0] = 0;
NRF_RTC1->EVTENCLR = 0x000f0003; // all clear
NRF_RTC1->EVTENSET = RTC_EVTEN_COMPARE0_Msk;
NRF_RTC1->PRESCALER = 4095;
// Set wake-up time
NRF_RTC1->CC[0] = 50;
// GPIOE
NRF_GPIO->PIN_CNF[21] =
    (GPIO_PIN_CNF_SENSE_Disabled << GPIO_PIN_CNF_SENSE_Pos)
    | (GPIO_PIN_CNF_DRIVE_S0S1 << GPIO_PIN_CNF_DRIVE_Pos)
    | (GPIO_PIN_CNF_PULL_Disabled << GPIO_PIN_CNF_PULL_Pos)
    | (GPIO_PIN_CNF_INPUT_Connect << GPIO_PIN_CNF_INPUT_Pos)
    | (GPIO_PIN_CNF_DIR_Output << GPIO_PIN_CNF_DIR_Pos);
NRF_GPIOTE->CONFIG[0] =
    (GPIOTE_CONFIG_POLARITY_LoToHi << GPIOTE_CONFIG_POLARITY_Pos)
    | (21 << GPIOTE_CONFIG_PSEL_Pos)
    | (GPIOTE_CONFIG_MODE_Task << GPIOTE_CONFIG_MODE_Pos);
// Set PPI
NRF_PPI->CH[0].EEP = (uint32_t)&NRF_RTC1->EVENTS_COMPARE[0];
NRF_PPI->CH[0].TEP = (uint32_t)&NRF_GPIOTE->TASKS_OUT[0];
// Enable only PPI channels 0
NRF_PPI->CHEN = PPI_CHEN_CH0_Enabled << PPI_CHEN_CH0_Pos;
// Restart RTC1
NRF_RTC1->TASKS_START = 1;
nrf_delay_us(MAX_RTC_TASKS_DELAY);
// DEBUG
PRINTF("NRF_RTC1->PRESCALER=0x%x\r\n", NRF_RTC1->PRESCALER);
PRINTF("NRF_RTC1->EVTEN=0x%x\r\n", NRF_RTC1->EVTEN);
PRINTF("NRF_RTC1->COUNTER=0x%x\r\n", NRF_RTC1->COUNTER);
PRINTF("NRF_RTC1->EVENTS_COMPARE[0]=0x%x\r\n", NRF_RTC1->EVENTS_COMPARE[0]);
PRINTF("NRF_RTC1->CC[0]=0x%x\r\n", NRF_RTC1->CC[0]);
do
{
    PRINTF("NRF_RTC1->EVENTS_COMPARE[0]=");
    PRINTF("%d", NRF_RTC1->EVENTS_COMPARE[0]);
    PRINTF(" %d", NRF_RTC1->CC[0]);
    PRINTF(" %d\r\n", NRF_RTC1->COUNTER);
    nrf_delay_us(125000);
} while(NRF_RTC1->EVENTS_COMPARE[0] == 0);
PRINTF("NRF_RTC1->EVENTS_COMPARE[0]=");
PRINTF("%d", NRF_RTC1->EVENTS_COMPARE[0]);
PRINTF(" %d", NRF_RTC1->CC[0]);
PRINTF(" %d\r\n", NRF_RTC1->COUNTER);
step_by_step('4');
// GPIOE
NRF_GPIO->PIN_CNF[21] =
    (GPIO_PIN_CNF_SENSE_Disabled << GPIO_PIN_CNF_SENSE_Pos)
    | (GPIO_PIN_CNF_DRIVE_S0S1 << GPIO_PIN_CNF_DRIVE_Pos)
    | (GPIO_PIN_CNF_PULL_Disabled << GPIO_PIN_CNF_PULL_Pos)
    | (GPIO_PIN_CNF_INPUT_Connect << GPIO_PIN_CNF_INPUT_Pos)
    | (GPIO_PIN_CNF_DIR_Output << GPIO_PIN_CNF_DIR_Pos);
NRF_GPIOTE->CONFIG[0] =
    (GPIOTE_CONFIG_POLARITY_LoToHi << GPIOTE_CONFIG_POLARITY_Pos)
    | (21 << GPIOTE_CONFIG_PSEL_Pos)
    | (GPIOTE_CONFIG_MODE_Task << GPIOTE_CONFIG_MODE_Pos);
// RTC1
NRF_RTC1->TASKS_STOP = 1;
NRF_RTC1->EVENTS_COMPARE[0] = 0;
NRF_RTC1->EVTENCLR = 0x000f0003; // all clear
NRF_RTC1->EVTENSET = RTC_EVTEN_COMPARE0_Msk;
NRF_RTC1->TASKS_CLEAR = 1;
NRF_RTC1->CC[0] = 100;
NRF_RTC1->PRESCALER = 4095;
do
{
    NRF_RTC1->TASKS_STOP = 1;
    NRF_RTC1->PRESCALER = 4095;
    PRINTF("Retry PRESCALER setting\r\n");
} while (NRF_RTC1->PRESCALER != 4095);
PRINTF("NRF_RTC1->PRESCALER=0x%x\r\n", NRF_RTC1->PRESCALER);
PRINTF("NRF_RTC1->EVTEN=0x%x\r\n", NRF_RTC1->EVTEN);
PRINTF("NRF_RTC1->COUNTER=0x%x\r\n", NRF_RTC1->COUNTER);
PRINTF("NRF_RTC1->EVENTS_COMPARE[0]=0x%x\r\n", NRF_RTC1->EVENTS_COMPARE[0]);
PRINTF("NRF_RTC1->CC[0]=0x%x\r\n", NRF_RTC1->CC[0]);
// PPI
NRF_PPI->CH[0].EEP = (uint32_t)&NRF_RTC1->EVENTS_COMPARE[0];
NRF_PPI->CH[0].TEP = (uint32_t)&NRF_GPIOTE->TASKS_OUT[0];
// Enable only PPI channels 0
NRF_PPI->CHEN = PPI_CHEN_CH0_Enabled << PPI_CHEN_CH0_Pos;
NRF_RTC1->TASKS_START = 1;
do
{
    PRINTF("NRF_RTC1->EVENTS_COMPARE[0]=");
    PRINTF("%d", NRF_RTC1->EVENTS_COMPARE[0]);
    PRINTF(" %d", NRF_RTC1->CC[0]);
    PRINTF(" %d\r\n", NRF_RTC1->COUNTER);
} while(NRF_RTC1->EVENTS_COMPARE[0] == 0);
PRINTF("NRF_RTC1->EVENTS_COMPARE[0]=");
PRINTF("%d", NRF_RTC1->EVENTS_COMPARE[0]);
PRINTF(" %d", NRF_RTC1->CC[0]);
PRINTF(" %d\r\n", NRF_RTC1->COUNTER);
break;
case '3' :
step_by_step('x');
p_out = 1;
step_by_step('y');
p_out = 0;
step_by_step('z');
for (int8_t n =0; n < 20; n++)
{
    p_out = 1;
    wait_ms(100);
    p_out = 0;
    wait_ms(100);
}
break;
case '4' :
PRINTF("Please make your own command!!\r\n");
PRINTF("Please see 9_Monitor\debug_tool\debugging_nRF5x.h\r\n");
PRINTF("line:%d\r\n", __LINE__);
step_by_step('x');
;
step_by_step('y');
;
step_by_step('z');
;
break;

// You don't need any terminate bracket such as '}'