/*
 * Mbed Application program
 *  SD Card file control function with FatFs on Mbed-os5
 *
 * Copyright (c) 2018 Kenji Arai / JH1PJL
 *  http://www.page.sannet.ne.jp/kenjia/index.html
 *  https://os.mbed.com/users/kenjiArai/
 *      Created:    April      4th, 2018
 *      Revised:    April     14th, 2018    only for TYBLE16
 */

//#define EXAMPLE_5_SDCARD
#ifdef EXAMPLE_5_SDCARD

//  Include --------------------------------------------------------------------
#include    "mbed.h"
#include    "SDBlockDevice.h"
#include    "FATFileSystem.h"
#include    "mon.h"
#include    "TYBLE16_BASE.h"
#include    <stdlib.h>

//  Definition -----------------------------------------------------------------
#define     USER_SW_ON      0

//  Constructor ----------------------------------------------------------------
DigitalOut      led(LED1);
DigitalIn       user_sw(BUTTON1, PullUp);
Serial          pc(USBTX, USBRX, 115200);
SDBlockDevice   sd(D3, D2, D0, D1, 8000000);
FATFileSystem   fs("fs");

//  RAM ------------------------------------------------------------------------

//  ROM / Constant data --------------------------------------------------------
char *const opngmsg =
    "\x1b[2J\x1b[H"__FILE__ "\r\n"__DATE__ " " __TIME__ " (UTC)\r\n""\r\n";
char *const opening_msg0 = "microSD Card test program";
char *const opening_msg1 = " -> run on Mbed OS-5\r\n";

//  Function prototypes --------------------------------------------------------

//------------------------------------------------------------------------------
//  Control Program
//------------------------------------------------------------------------------
int main()
{
    time_t      seconds;
    uint32_t data0 = 10000U;
    uint32_t data1 = 20000U;
    uint32_t data2 = 30000U;
    uint32_t data3 = 40000U;
    uint32_t data4 = 50000U;
    uint32_t data5 = 60000U;

    pc.puts(opngmsg);
    // Check TYBLE-16 configuration
    cpu_sys();
    compile_condition();
    if (user_sw == USER_SW_ON) {
        mon();
    }
    //pc.printf("line:%d\r\n", __LINE__);
    /* Init SD CARD reader */
    sd.init();
    fs.mount(&sd);
    FILE* fp = fopen("/fs/mydata.txt", "a");
    if (fp != 0) {
        pc.printf("%s%s",  opening_msg0, opening_msg1);
        fprintf(fp,"%s%s", opening_msg0, opening_msg1);
    } else {
        pc.printf("ERROR\r\n");
    }
    fclose(fp);
    while (pc.readable()) {
        char c = pc.getc(); // dummy read
    }
    while (true) {
        uint32_t size = get_disk_freespace();
        pc.printf("free %u  ", size);
        fp = fopen("/fs/mydata.txt", "a");
        if(fp != 0) {
            char tmp[64];
            seconds = time(NULL);
            strftime(tmp, 64, "TYBLE16 %H:%M:%S,%Y/%m/%d,", localtime(&seconds));
            pc.printf(tmp);
            fprintf(fp, "%s", tmp);
            pc.printf("%08d;%08d;%08d;%08d;%08d;%08d\r\n",
                      ++data0, ++data1, ++data2, ++data3, ++data4, ++data5);
            fprintf(fp, "%08d;%08d;%08d;%08d;%08d;%08d\r\n",
                    data0,   data1,   data2,   data3,   data4,   data5);
        } else {
            pc.printf("ERROR\r\n");
        }
        fclose(fp);
        Thread::wait(100);
        if (user_sw == USER_SW_ON) {
            break;
        }
        if (pc.readable()) {
            mon();
        }
        led = !led;
    }
    while(true) {
        mon();
        NVIC_SystemReset();
    }
}

#endif
