/*
 * Mbed Application program / Blinky
 *
 * Copyright (c) 2018 Kenji Arai / JH1PJL
 *  http://www.page.sannet.ne.jp/kenjia/index.html
 *  http://mbed.org/users/kenjiArai/
 *      Created:    April     10th, 2018
 *      Revised:    April     10th, 2018
 */
 
//  Include --------------------------------------------------------------------
#include "mbed.h"
#include "TYBLE16_BASE.h"

//  Definition -----------------------------------------------------------------

//  Constructor ----------------------------------------------------------------
DigitalOut  my_led(LED1);
Serial      pc(USBTX, USBRX);
 
//  RAM ------------------------------------------------------------------------
 
//  ROM / Constant data --------------------------------------------------------
char *const opngmsg =
    "\x1b[2J\x1b[H"__FILE__ "\r\n"__DATE__ " " __TIME__ " (UTC)\r\n""\r\n";

//  Function prototypes --------------------------------------------------------
 
//------------------------------------------------------------------------------
//  Control Program
//------------------------------------------------------------------------------
int main()
{
    uint32_t count = 0;

    pc.puts(opngmsg);
    // Check TYBLE-16 configuration
    cpu_sys();
    compile_condition();
    while(true) {
        my_led = !my_led;
        pc.printf("%8u\r\n", count++);
        Thread::wait(1000);
    }
}
