/*
 * Mbed Application program / Using Akizuki BLE Module AE-TYBLE16
 *      on-board module : TAIYO YUDEN BLE 4.2 TYSA-B (EYSGJNAWY-WX)
 *
 *  http://akizukidenshi.com/catalog/g/gK-12339/
 *
 * Copyright (c) 2017 Kenji Arai / JH1PJL
 *  http://www.page.sannet.ne.jp/kenjia/index.html
 *  http://mbed.org/users/kenjiArai/
 *      Created:    October   29th, 2017
 *      Revised:    October   29th, 2017
 */

//  Include --------------------------------------------------------------------
#include "mbed.h"
#include "TextLCD.h"

//  Definition -----------------------------------------------------------------

//  Object/ Constructor --------------------------------------------------------
Serial      pc(P0_1, P0_3);
DigitalOut  led(P0_5);
I2C         i2c(P0_0, P0_2);
TextLCD_I2C_N   lcd(&i2c, 0x7c, TextLCD::LCD16x2);  // LCD(Akizuki  AQM1602A)

//  RAM ------------------------------------------------------------------------

//  ROM / Constant data --------------------------------------------------------

//  Function prototypes --------------------------------------------------------

//------------------------------------------------------------------------------
//  Control Program
//------------------------------------------------------------------------------
int main()
{                    // 1234567890123456
    char lcd_buf[20] = "by K.Arai/JH1PJL";
    uint32_t n = 0;

    pc.printf("\r\n\r\nApplication for AE-TYBLE16 Module\r\n");
    pc.printf("  created on %s %s (UTC)\r\n", __DATE__, __TIME__);
    // lcd
    lcd.locate(0, 0);       // 1st line top
    lcd.puts("1234567890123456");
    lcd.locate(0, 1);       // 2nd line top
    lcd.printf("%s", lcd_buf);
    lcd.setCursor(TextLCD_Base::CurOff_BlkOff);
    lcd.setContrast(0x1b);  // for AE-AQM1602A
    wait(5.0f);
    while (true){
        sprintf(lcd_buf, "passed %5d sec", n++);
        pc.printf(" %sonds\r\n", lcd_buf);
        lcd.locate(0, 0);   // 1st line
        lcd.printf("%s", lcd_buf);
        led = !led;
        wait(1.0f);
    }
}

