/*
 *      December 31st, 2015     Modified by Kenji Arai
 *		January  19th, 2016
 *		October  12th, 2017		!! Run on Mbed-os5
 *                              http://www.page.sannet.ne.jp/kenjia/index.html
 *                              https://os.mbed.com/users/kenjiArai/
 *		April    14th, 2018		run on TYBLE16
 *      January  23rd, 2020		TYBLE16(mbed-os5.1.5.0)
 *
 *  Original:
 *   BLE_RCBController2_Motor
 *   https://developer.mbed.org/users/robo8080/code/BLE_RCBController2_Motor/
 *  Tested Controller Device:
 *   iPhone6 RCBController (Ver1.4.0)
 *   https://itunes.apple.com/jp/app/rcbcontroller/id689724127?mt=8
 */

#include "mbed.h"
#include "BLE.h"
#include "RCBController.h"
#include "TYBLE16_BASE.h"
#include "drf0534.h"

#define NEED_CONSOLE_OUTPUT	 0 // Keep 1

#if NEED_CONSOLE_OUTPUT
#define DEBUG(...) { pc.printf(__VA_ARGS__); }
#else
#define DEBUG(...)
#endif

//BLE  		ble_rcb;
BLE &ble_rcb = BLE::Instance();
#if NEED_CONSOLE_OUTPUT
Serial      pc(USBTX, USBRX);
#else
DFR0534 	mp3(USBTX, USBRX, A0);  // tx, rx, busy
#endif

uint8_t RCBControllerPayload[10] = {0,};
RCBController 		controller;

// RCBController Service
static const uint16_t RCBController_service_uuid = 0xFFF0;
static const uint16_t RCBController_Characteristic_uuid = 0xFFF1;
const char *deviceName = "Mbed-BLE";
const char *const opngmsg =
    "\x1b[2J\x1b[H" __FILE__ "\r\n" __DATE__ " " __TIME__ " (UTC)\r\n""\r\n";

GattCharacteristic  ControllerChar (
    RCBController_Characteristic_uuid,RCBControllerPayload,10, 10,
    GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_WRITE |
    GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_WRITE_WITHOUT_RESPONSE
);
GattCharacteristic *ControllerChars[] = {&ControllerChar};
GattService         RCBControllerService(
    RCBController_service_uuid,
    ControllerChars,
    sizeof(ControllerChars) / sizeof(GattCharacteristic *)
);

//------------------------------------------------------------------------------
//  Control Program
//------------------------------------------------------------------------------
void data_analysis(void)
{
    static uint8_t key = 0;
	static bool idle = true;
	static bool previous_key = 0;

    uint16_t key_data = (controller.data[0] << 8) + controller.data[1];
    switch(key_data) {
        case    0:
            key =  0;
            idle = true;
            break;
        case    1:
            key = 11;
            if (idle == true) {
            	idle = false;
            	mp3.play_one(key);
            }
            break;
        case    2:
            key = 15;
            break;
        case    4:
            key = 16;
            break;
        case    5:
            key = 12;
            if (idle == true) {
            	idle = false;
            	mp3.play_one(key);
            }
            break;
        case    6:
            key = 17;
            break;
        case    8:
            key = 13;
            if (idle == true) {
            	idle = false;
            	mp3.volume_increase();
            }
            break;
        case    9:
            key = 10;
            if (idle == true) {
            	idle = false;
            	mp3.play_one(key);
            }
            break;
        case   10:
            key = 14;
            if (idle == true) {
            	idle = false;
            	mp3.volume_decrease();
            }
            break;
        case   16:
            key =  2;
            if (idle == true) {
            	idle = false;
            	mp3.play_one(key);
            }
            break;
        case   32:
            key =  8;
            if (idle == true) {
            	idle = false;
            	mp3.play_one(key);
            }
            break;
        case   64:
            key =  6;
            if (idle == true) {
            	idle = false;
            	mp3.play_one(key);
            }
            break;
        case   80:
            key =  3;
            if (idle == true) {
            	idle = false;
            	mp3.play_one(key);
            }
            break;
        case   96:
            key =  9;
            if (idle == true) {
            	idle = false;
            	mp3.play_one(key);
            }
            break;
        case  128:
            key =  5;
            if (idle == true) {
            	idle = false;
            	mp3.play_one(key);
            }
            break;
        case  256:
            key =  4;
            if (idle == true) {
            	idle = false;
            	mp3.play_one(key);
            }
            break;
        case  272:
            key =  1;
            if (idle == true) {
            	idle = false;
            	mp3.play_one(key);
            }
            break;
        case  288:
            key =  7;
            if (idle == true) {
            	idle = false;
            	mp3.play_one(key);
            }
            break;
        case  512:
            key = 18;
            if (idle == true) {
            	idle = false;
            	mp3.command(Prev_Audio);
            }
            break;
        case 1024:
            key = 19;
            if (idle == true) {
            	idle = false;
            	mp3.command(Play);
            }
            break;
        case 2048:
            key = 21;
            if (idle == true) {
            	idle = false;
            	uint32_t num = mp3.total_num_of_audio();
		        for (uint32_t i = 1; i < num + 1; i++) {
		            mp3.play_one(i);
		        }
            }
            break;
        case 4096:
            key = 20;
            if (idle == true) {
            	idle = false;
            	mp3.command(Next_Audio);
            }
            break;
        default:
            key = 0;
    }
    DEBUG("DATA:%d\r\n", key);
}

void disconnectionCallback(const Gap::DisconnectionCallbackParams_t *params)
{
    DEBUG("Disconnected!\r\n");
    DEBUG("Restarting the advertising process\r\n");
    ble_rcb.gap().startAdvertising();
}

void onDataWritten(const GattWriteCallbackParams *params)
{
    if (params->handle == ControllerChar.getValueAttribute().getHandle()) {
        uint16_t bytesRead;
        ble_rcb.gattServer().read(
        //ble_rcb.readCharacteristicValue(
            ControllerChar.getValueAttribute().getHandle(),
            RCBControllerPayload, &bytesRead
        );
        memcpy( &controller.data[0], RCBControllerPayload, sizeof(controller));
        DEBUG("DATA:0x%02x 0x%02x %d %d %d %d %d %d %d 0x%02x\r\n",
              controller.data[0],controller.data[1],
              controller.data[2],controller.data[3],
              controller.data[4],controller.data[5],
              controller.data[6],controller.data[7],
              controller.data[8],controller.data[9]
             );
        uint16_t key_data = (controller.data[0] << 8) + controller.data[1];
        DEBUG("DATA:%d\r\n", key_data);
        data_analysis();
    }
}

int main(void)
{
    mp3.volume_setting(0);
    DEBUG("%s", opngmsg);
    DEBUG("\r\nInitialising the nRF51822\r\n");
    // Check TYBLE-16 configuration
    //cpu_sys();
    //compile_condition();

    ble_rcb.init();
    ble_rcb.gap().setDeviceName((const uint8_t *)deviceName);
    ble_rcb.gap().onDisconnection(disconnectionCallback);
    ble_rcb.gattServer().onDataWritten(onDataWritten);
    DEBUG("Start RCB Controller\r\n");
    /* setup advertising */
    ble_rcb.gap().accumulateAdvertisingPayload(
        GapAdvertisingData::BREDR_NOT_SUPPORTED
    );
    ble_rcb.gap().setAdvertisingType(
        GapAdvertisingParams::ADV_CONNECTABLE_UNDIRECTED
    );
    ble_rcb.gap().accumulateAdvertisingPayload(
        GapAdvertisingData::SHORTENED_LOCAL_NAME,
        (const uint8_t *)deviceName, strlen(deviceName)
    );
    ble_rcb.gap().accumulateAdvertisingPayload(
        GapAdvertisingData::COMPLETE_LIST_16BIT_SERVICE_IDS,
        (const uint8_t *)RCBController_service_uuid,
        sizeof(RCBController_service_uuid)
    );
    ble_rcb.gap().setAdvertisingInterval(160); /* 100ms; in multiples of 0.625ms. */
    ble_rcb.gap().startAdvertising();
    ble_rcb.gattServer().addService(RCBControllerService);
    while (true) {
        ble_rcb.waitForEvent();
    }
}
