/*
 *		Modifed by Kenji Arai on December 31st, 2015
 */

typedef union {
    struct  {
        /*
        1st and 2nd byte: buttom
        　UP: 0x0001
        　DOWN: 0x0002
        　RIGHT: 0x0004
        　LEFT: 0x0008
        　Y button: 0x0010
        　A button: 0x0020
        　B button: 0x0040
        　X button: 0x0100
        　L1: 0x0200
        　L2: 0x0400
        　R1: 0x0800
        　R2: 0x1000
        　START: 0x0003
        　SELECT: 0x000C
        */
        unsigned X		: 1;
        unsigned L1		: 1;
        unsigned L2		: 1;
        unsigned R1		: 1;
        unsigned R2		: 1;
        unsigned space1	: 3;
        unsigned UP		: 1;
        unsigned DOWN	: 1;
        unsigned RIGHT	: 1;
        unsigned LEFT	: 1;
        unsigned Y		: 1;
        unsigned A		: 1;
        unsigned B		: 1;
        unsigned space2	: 1;
        /*
        3rd and 4th byte: Analog value (left side)
        　Left to Right: 1-255 (Neutral=128)
        　Down to UP   : 1-255 (Neutral=128)
        */
        unsigned LeftAnalogLR:8;
        unsigned LeftAnalogUD:8;
        /*
        5th to 6th byte: Analog value (Right side)
        　Left to Right: 1-255 (Neutral=128)
        　Down to UP   : 1-255 (Neutral=128)
        */
        unsigned RightAnalogLR:8;
        unsigned RightAnalogUD:8;
        /*
        7th to 9th byte: Accel
        　X-axis: 1-255 (Neutral=128)
        　Y-axis: 1-255 (Neutral=128)
        　Z-axis: 1-255 (Neutral=128)
        */
        unsigned AcceleX:8;
        unsigned AcceleY:8;
        unsigned AcceleZ:8;
        /*
        10th byte       : Setting parameter
         7th and 6th bit: setting accel (0-3)
         5th bit        : Analog-Left (0 or 1)
         4th bit        : Analog-Right (0 or 1)
         3th to 1st bit : iOS device direction (1-4)
        */
        unsigned DEV_DIR:4;
        unsigned RIGHT_ANALOG:1;
        unsigned LEFT_ANALOG:1;
        unsigned ACCELE_SETTING:2;
    } status;
    unsigned char data[10];
} RCBController;
