// Modified by K.Arai / JH1PJL     May 15th, 2020

#include "SoftSerial_IR.h"

SoftSerial_IR::SoftSerial_IR(PinName TX, PinName RX, const char* name)
{
    tx_en = rx_en = false;
    read_buffer = 0;
    if (TX != NC) {
        //tx = new DigitalOut(TX);
        tx = new PwmOut(TX);
        tx_en = true;
        tx->period(1.0f / 38000.0f);    // PWM = 38kHz
        //tx->write(1);
        tx->write(0.0f);
        tx_bit = -1;
        txticker.attach(this, &SoftSerial_IR::tx_handler);
    }
    if (RX != NC) {
        rx = new InterruptIn(RX);
        rx_en = true;
        out_valid = false;
        rxticker.attach(this, &SoftSerial_IR::rx_handler);
        rx->fall(callback(this, &SoftSerial_IR::rx_gpio_irq_handler));
    }

    baud(2400);
    format();
}

SoftSerial_IR::~SoftSerial_IR()
{
    if (tx_en) {
        delete(tx);
    }
    if (rx_en) {
        delete(rx);
    }
}

void SoftSerial_IR::baud(int baudrate)
{
    bit_period = 1000000 / baudrate;
}

void SoftSerial_IR::format(int bits, Parity parity, int stop_bits)
{
    _bits = bits;
    _parity = parity;
    _stop_bits = stop_bits;
    _total_bits = 2 + _bits + _stop_bits + (bool)_parity;
}
