//A modified version of the regular ticker/timeout libraries
//      to allow us to do timeout without losing accuracy

// Modified by K.Arai / JH1PJL     May 12th, 2020

#ifndef FLEXTICKER_H
#define FLEXTICKER_H

#include "mbed.h"

class FlexTicker: public TimerEvent
{
public:
    template<typename T>
    void attach(T* tptr, void (T::*mptr)(void))
    {
        _function = Callback<void()>(tptr, mptr);
    }

    /** Detach the function
     */
    void detach()
    {
        remove();
    }

    void setNext(int delay)
    {
        insert(event.timestamp + delay);
    }

    void prime(int comp_time = 0)
    {
        event.timestamp = us_ticker_read() + comp_time;
    }

protected:
    virtual void handler()
    {
        _function.call();
    }

    unsigned int _delay;
    Callback<void()> _function;
};

#endif