// Modified by K.Arai / JH1PJL     May 12th, 2020

#include "SoftSerial.h"

// please make a constructor in main.cpp if you use below pc & led
#if DEBUG_TIMING == 1
    extern Serial pc;
    extern DigitalOut test_point;
#   define TP_ON   {test_point = 1;}
#   define TP_OFF  {test_point = 0;}
#   define DBG_PRINTF(...) pc.printf(__VA_ARGS__)
#else
#   define TP_ON   {;}
#   define TP_OFF  {;}
#   define DBG_PRINTF(...) {;}
#endif

int SoftSerial::_putc(int c)
{
    while(!writeable()) {
        YIELD;
    }
    prepare_tx(c);
    tx_bit = 0;
    tx->write(1);
    txticker.prime();
    tx_handler();
    return 0;
}

void SoftSerial::send_break(void) {
    while(!writeable()) {
        YIELD;
    }
    //Just to make sure it appears as non-writable to other threads/IRQs
    tx_bit = 0;         
    tx->write(0);
    wait_us((bit_period * _total_bits * 3) / 2);
    tx->write(1);
    tx_bit = -1;
}

int SoftSerial::writeable(void)
{
    if (!tx_en) {
        return false;
    }
    if (tx_bit == -1) {
        return true;
    }
    return false;
}

void SoftSerial::tx_handler(void)
{
    TP_ON;
    if (tx_bit == _total_bits) {
        tx_bit = -1;
        tx->write(1);
        fpointer[TxIrq].call();
        TP_OFF;
        return;
    }
    if (tx_bit == 0){
        tx->write(1);
        txticker.setNext(10);
    } else {
        int bitchk = _char >> tx_bit;
        if (bitchk & 1) {
            tx->write(1);
        } else {
            tx->write(0);
        }
        txticker.setNext(bit_period);
    }
    tx_bit++;
    TP_OFF;
}

void SoftSerial::prepare_tx(int c)
{
    _char = c << 2;   // set start bit as bit1 and dummy as bit0

    bool parity;
    switch (_parity) {
        case Forced1:
            _char |= 1 << (_bits + 1);
            break;
        case Even:
            parity = false;
            for (int i = 0; i<_bits; i++) {
                if (((_char >> i) & 0x01) == 1) {
                    parity = !parity;
                }
            }
            _char |= parity << (_bits + 1);
            break;
        case Odd:
            parity = true;
            for (int i = 0; i<_bits; i++) {
                if (((_char >> i) & 0x01) == 1) {
                    parity = !parity;
                }
            }
            _char |= parity << (_bits + 1);
            break;
        case Forced0:
        case None:
        default:
            ;
    }
    // added one dummy at LSB bit
    int num = 1 + _bits + (bool)_parity + 1;
    _char |= 0xffffffff << num;
    _char |= 1UL;
    _char &= ~(1 << _total_bits);
}
