/*
 * mbed Library program
 *      Check & set RTC function and set proper clock if we can set
 *      ONLY FOR "Nucleo Board"
 *
 *  Copyright (c) 2014,'15,'16 Kenji Arai / JH1PJL
 *  http://www.page.sannet.ne.jp/kenjia/index.html
 *  http://mbed.org/users/kenjiArai/
 *      Created: October   24th, 2014
 *      Revised: May       28th, 2016
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED,
 * INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE
 * AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
 * DAMAGES OR OTHER  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

/*
 * CAUTION! You need to modify "rtc_api.c" file in the mbed-dev library.
 *          Please refer "modify_info_xxx.h" file and/or following my notebook.
 *          http://developer.mbed.org/users/kenjiArai/notebook/
 *              nucleo-series-rtc-control-under-power-onoff-and-re/
 */

#ifndef SET_RTC_H
#define SET_RTC_H

#include "mbed.h"

#if defined(TARGET_STM32L152RE)
#define USE_IRQ_FOR_RTC_BKUP    // Use interrupt for enter RTC backup mode
#define USE_PB5_FOR_COMP        // Use PB5 port for low voltage detection (+5V line)
//#define USE_PB6_FOR_COMP        // Use PB6 port for low voltage detection (+5V line)
#endif

#define TIMEOUT     ((uint32_t)5000)
#define RTC_DAT0    0x55aa55aa
#define RTC_DAT1    0xaa55aa55

/** Check and set RTC module inside Nucleo STM32X CPU.
 *      Latest Nucleo board has external LSE Crystal X2 but no proper setting both HW ans SW.
 *      In addition, every power on and/or reset make initial condition even HW Backup condition.
 *      This is cased by mbed initial subroutine problem.
 *      This program intends to use RTC with X2 and works well with battery back-up hardware setting.
 *
 *
 * @code
 * #include "mbed.h"
 * #include "SetRTC.h"
 *
 * int main() {
 *   time_t seconds;
 *
 *   if (SetRTC(0) == 1) { // No use COMP(PB5 or 6) (only L152RE)
 *       PRINTF("Use External CLK (Good for RTC)\r\n");
 *   } else {
 *       PRINTF("Use Internal CLK (Bad for RTC)\r\n");
 *   }
 *   printf("Time: %s", ctime(&seconds));
 * }
 * @endcode
 */

/** Check and Set RTC
  * @param use_comparator = 1 Use COMP(only for L152 PB5 or 6 set-up), =0 no HW modification
  * @return if proper setting = 1, if not = 0
  */
int32_t SetRTC(uint8_t use_comparator);

/** Show(print) RTC related registers
  * @param none
  * @return none
  */
void show_RTC_reg( void );

/** Enter RTC initial data from PC Vertual Com
  * @param none
  * @return none
  */
void time_enter_mode(void);

/** Go to Standbay Mode (Set I/O port and other peripheral low power condition)
  * @param none
  * @return none
  */
void goto_standby(void);

#endif      // SET_RTC_H
