#include "mbed.h"
#include "USBSerial.h"

Serial pc(USBTX, USBRX, 921600);
// Virtual USB Serial port
USBSerial usb_serial;
DigitalOut led(LED1);
Timer t;

int main(void)
{
    uint32_t i = 0;
    uint32_t dt;

    // Print on STDIO
    printf("USBDevice Serial started\r\n");

    while(1) {
        t.reset();
        t.start();
#if 1
        // Print on Virtual USB Serial port
        usb_serial.printf("I am a virtual serial port: %d, %d\r\n", i++, dt);
#else
        // Print on V-COM
        pc.printf("I am a virtual serial port: %d, %d\r\n", i++, dt);
#endif
        led = !led;
        dt = t.read_us();
    }
}
