/*
 * Mbed Application program
 *      USB Memory control
 *
 * Copyright (c) 2019,'20 Kenji Arai / JH1PJL
 *  http://www.page.sannet.ne.jp/kenjia/index.html
 *  http://mbed.org/users/kenjiArai/
 *      Created:    March     14th, 2019
 *      Revised:    January    5th, 2020
 */

/*
    Tested board on OS5.14.2
        Nucleo-F401RE, -F411RE, -F446RE, -F446ZE
        DISCO-F469NI
 */
 
//  Include --------------------------------------------------------------------
#include "mbed.h"
#include "USBHostMSD.h"
#include "mon.h"

//  Definition -----------------------------------------------------------------
#define     USER_SW_ON      0
#define     LOOP_TIME       50      // 50mS

#define DEBUG_PRINT  0
#if DEBUG_PRINT
#define DBG(...)    pc.printf(__VA_ARGS__)
#else
#define DBG(...)    {;}
#endif

//  Object ---------------------------------------------------------------------
DigitalIn user_sw(BUTTON1, PullUp);
Serial pc(USBTX, USBRX, 115200);
Timer tmr;

//  RAM ------------------------------------------------------------------------

//  ROM / Constant data --------------------------------------------------------

//  Function prototypes --------------------------------------------------------
void no_good_and_wait_reset(void);

//------------------------------------------------------------------------------
//  Control Program
//------------------------------------------------------------------------------
int main()
{
    uint32_t data0 = 10000U;
    uint32_t data1 = 20000U;
    uint32_t data2 = 30000U;
    uint32_t data3 = 40000U;
    uint32_t data4 = 50000U;
    uint32_t data5 = 60000U;

    DBG("line:%d\r\n", __LINE__);
    while (pc.readable()) {
        pc.getc();
    }
    pc.printf("\r\n\r\nPlease connect USB memory!  ");
    pc.printf("If you have connected it, please hit any key to go next.\r\n");
    while (pc.readable() == 0) {
        ThisThread::sleep_for(100);
    }
    pc.getc();
    pc.printf("\nStart USB memory test.\r\n");

    USBHostMSD  msd;
    DBG("line:%d\r\n", __LINE__);
    msd.init();

    uint32_t out = 50;
    DBG("line:%d\r\n", __LINE__);
    while(!msd.connect()) {
        if (--out == 0) {
            DBG("line:%d\r\n", __LINE__);
            pc.printf("Cannot detect USB memory!! \r\n");
            break;
        }
        pc.putc('.');
        ThisThread::sleep_for(1000);
    }
    if (out != 0) {
        pc.printf("\r\nDetect USB memory on USB connector.\r\n");
    } else {
        DBG("line:%d\r\n", __LINE__);
        no_good_and_wait_reset();
    }
    FATFileSystem fs("usb");
    DBG("line:%d\r\n", __LINE__);
    FILE *fp;
    time_t seconds;

    if (fs.mount(&msd) == 0) {
        DBG("line:%d\r\n", __LINE__);
        fp = fopen("/usb/mydata.txt", "a");
        DBG("line:%d\r\n", __LINE__);
        if (fp == 0) {
            pc.printf("Cannot write a file into USB memory.\r\n");
            no_good_and_wait_reset();
        } else {
            pc.printf("Succeed file open, write and close.\r\n");
            fclose(fp);
        }
    }
    DBG("line:%d\r\n", __LINE__);
    while(pc.readable()) {
        DBG("line:%d\r\n", __LINE__);
        pc.getc();
    }
    pc.printf("Start contunuos file write.\r\n");
    pc.printf("If you want to stop, please hit any key!\r\n");
    uint32_t num = 0;
    char buf[64];
    while (pc.readable() == 0) {
        ThisThread::sleep_for(100);
    }
    pc.getc();
    pc.printf("Time[mS]:     ");
    while(true) {
        tmr.reset();
        tmr.start();
        uint32_t size_disk = get_disk_freespace();
        uint32_t size_file = get_data_file_size("mydata.txt");
        pc.printf("free disk:%10u, file:%8u  ", size_disk, size_file);
        fp = fopen("/usb/mydata.txt", "a");
        if(fp != 0) {
            char tmp[64];
            DBG("line:%d\r\n", __LINE__);
            seconds = time(NULL);
            strftime(tmp, 64, "DATE %H:%M:%S,%Y/%m/%d,", localtime(&seconds));
            pc.printf("%s", tmp);
            fprintf(fp, "%s", tmp);
            pc.printf("%08d;%08d;%08d;%08d;%08d;%08d\r\n",
                      ++data0, ++data1, ++data2, ++data3, ++data4, ++data5);
            fprintf(fp, "%08d;%08d;%08d;%08d;%08d;%08d\r\n",
                        data0,   data1,   data2,   data3,   data4,   data5);
            fclose(fp);
        } else {
            pc.printf("ERROR\r\n");
        }
        uint32_t time_sd = tmr.read_ms();
        pc.printf("Time[mS]:%4d ", time_sd);
        if (time_sd < LOOP_TIME -2){
            ThisThread::sleep_for(LOOP_TIME - time_sd);
        }
        if (user_sw == USER_SW_ON) {
            break;
        }
        if (pc.readable()) {
            break;
        }
    }
    pc.getc();
    pc.printf("\r\nStop file write.\r\n");
    pc.printf("Do you want to check detail?\r\n");
    pc.printf("If so, please enter 'y'.\r\n");
    if (pc.getc() == 'y') {
        mon();
    }
    pc.printf("If you want to tray again, ");
    no_good_and_wait_reset();
}

void no_good_and_wait_reset()
{
    pc.printf("Please enter [Alt]+B for re-start.\r\n");
    while(true) {
        ThisThread::sleep_for(1000);
    }
}
